//----------------------------------------------------------------------------------------
// File : ForwardPS.hlsl
// Desc : Forward Shading [Pixel Shader]
// Copyright(c) Project Asura. All right reserved.
//----------------------------------------------------------------------------------------

// ~ł.
#define PI          3.1415926535f

//////////////////////////////////////////////////////////////////////////////////////////
// VSOutput structure
//////////////////////////////////////////////////////////////////////////////////////////
struct VSOutput
{
    float4  Position    : SV_POSITION;          //!< XN[Ԃ̈ʒuWł.
    float4  WorldPos    : WORLD_POSIITON;       //!< [hԂ̈ʒuWł.
    float3  Normal      : NORMAL;               //!< @xNgł.
    float2  TexCoord    : TEXCOORD0;            //!< eNX`Wł.
    float3  LightDir    : LIGHT_DIRECTION;      //!< Cg̕xNgł.
    float3  CameraPos   : CAMERA_POSITION;      //!< Jʒuł.
    float4  SplitPos    : SPLIT_POSITION;       //!< JXP[hVhE}bvp.
    float4  SdwCoord[4] : SHADOW_COORD;         //!< JXP[hVhE}bvpʒuW.
};

//////////////////////////////////////////////////////////////////////////////////////////
// PSOutput structure
//////////////////////////////////////////////////////////////////////////////////////////
struct PSOutput
{
    float4 Color : SV_TARGET0;          //!< ^[Qbg0̏o̓J[ł.
};

/////////////////////////////////////////////////////////////////////////////////////////
// Material Buffer
/////////////////////////////////////////////////////////////////////////////////////////
cbuffer Material : register( b0 )
{
    float3 Diffuse  : packoffset( c0 );     //!< gUːFł.
    float  Alpha    : packoffset( c0.w );   //!< ߓxł.
    float3 Specular : packoffset( c1 );     //!< ʔːFł.
    float  Power    : packoffset( c1.w );   //!< ʔˋxł.
    float3 Emissive : packoffset( c2 );     //!< ȏƖFł.
    float  Bump     : packoffset( c2.w );   //!< ov}bsOtO.
};


//---------------------------------------------------------------------------------------
// Textures
//---------------------------------------------------------------------------------------
Texture2D       DiffuseMap    : register( t0 );     //!< fBt[Y}bvł.
Texture2D       SpecularMap   : register( t1 );     //!< XyL[}bvł.
Texture2D       BumpMap       : register( t2 );     //!< ov}bvł.
Texture2D       ShadowMap0    : register( t3 );     //!< VhE}bv(JXP[h0)ł.
Texture2D       ShadowMap1    : register( t4 );     //!< VhE}bv(JXP[h1)ł.
Texture2D       ShadowMap2    : register( t5 );     //!< VhE}bv(JXP[h2)ł.
Texture2D       ShadowMap3    : register( t6 );     //!< VhE}bv(JXP[h3)ł.


//---------------------------------------------------------------------------------------
// Samplers
//---------------------------------------------------------------------------------------
SamplerState            DiffuseSmp    : register( s0 );     //!< fBt[Y}bvpTv[Xe[gł.
SamplerState            SpecularSmp   : register( s1 );     //!< XyL[}bvpTv[Xe[gł.
SamplerState            BumpSmp       : register( s2 );     //!< ov}bvpTv[Xe[gł.
SamplerComparisonState  ShadowSmp     : register( s3 );     //!< VhE}bvpTv[rXe[gł.


//-----------------------------------------------------------------------------------------------
//! @biref      Ko[gCeBOvZ܂.
//!
//! @param [in]     diffuse     gUːF.
//! @param [in]     lightDir    CgxNg.
//! @param [in]     normal      @xNg.
//! @return     o[gCeBOʂԋp܂.
//-----------------------------------------------------------------------------------------------
float3 NormalizedLambert( float3 diffuse, float3 lightDir, float3 normal )
{
   return diffuse * max( dot( normal, lightDir ), 0.0f ) * ( 1.0f / PI );
}

//------------------------------------------------------------------------------------------------
//! @brief      KtHCeBOs܂.
//!
//! @param [in]     specular    ʔːF.
//! @param [in]     power       ʔˋx.
//! @param [in]     viewDir     xNg.
//! @param [in]     normal      @xNg.
//! @parma [in]     lightDir    CgxNg.
//! @return     tHCeBǑʂԋp܂.
//------------------------------------------------------------------------------------------------
float3 NormalizedPhong( float3 specular, float power, float3 viewDir, float3 normal, float3 lightDir )
{
    float3 R = -viewDir + ( 2.0f * dot( normal, viewDir ) * normal );

    return specular * pow( max ( dot( lightDir, R ), 0.0f ), power ) * ( ( power + 1.0f )/ ( 2.0 * PI ) );
}


//------------------------------------------------------------------------------------------------
//! @brief      sNZVF[_̃Gg[|Cgł.
//------------------------------------------------------------------------------------------------
PSOutput PSFunc( VSOutput input )
{
    PSOutput output = (PSOutput)0;

    // fBt[Y}bvtFb`.
    float4 mapKd = DiffuseMap.Sample( DiffuseSmp, input.TexCoord );

    // At@eXg.
    clip( ( mapKd.a < 0.125f ) ? -1.0f : 1.0f );

    // XyL[}bvtFb`.
    float4 mapKs = SpecularMap.Sample( SpecularSmp, input.TexCoord );

    float sdwThreshold = 1.0f;      // VhEɂ邩ǂ臒lł.
    float sdwBias      = 0.01f;     // VhEoCAXł.
    float sdwColor     = 0.1f;      // VhẼJ[ł.

    // esNZʒu܂ł̋.
    float dist = input.Position.w;  // r[ԂłZW.

    //int index = 0;
    if ( dist < input.SplitPos.x )
    {
        //index = 0;
        float2 coord = input.SdwCoord[0].xy / input.SdwCoord[0].w;
        float  depth = input.SdwCoord[0].z  / input.SdwCoord[0].w;
        sdwThreshold = ShadowMap0.SampleCmpLevelZero( ShadowSmp, coord, depth - sdwBias );
        sdwThreshold = saturate( sdwThreshold + sdwColor );
    }
    else if ( dist < input.SplitPos.y )
    {
        //index = 1;
        float2 coord = input.SdwCoord[1].xy / input.SdwCoord[1].w;
        float  depth = input.SdwCoord[1].z  / input.SdwCoord[1].w;
        sdwThreshold = ShadowMap1.SampleCmpLevelZero( ShadowSmp, coord, depth - sdwBias );
        sdwThreshold = saturate( sdwThreshold + sdwColor );
    }
    else if ( dist < input.SplitPos.z )
    {
        //index = 2;
        float2 coord = input.SdwCoord[2].xy / input.SdwCoord[2].w;
        float  depth = input.SdwCoord[2].z  / input.SdwCoord[2].w;
        sdwThreshold = ShadowMap2.SampleCmpLevelZero( ShadowSmp, coord, depth - sdwBias );
        sdwThreshold = saturate( sdwThreshold + sdwColor );
    }
    else
    {
        //index = 3;
        float2 coord = input.SdwCoord[3].xy / input.SdwCoord[3].w;
        float  depth = input.SdwCoord[3].z  / input.SdwCoord[3].w;
        sdwThreshold = ShadowMap3.SampleCmpLevelZero( ShadowSmp, coord, depth - sdwBias );
        sdwThreshold = saturate( sdwThreshold + sdwColor );
    }

    // XyL[}bvtFb`.
    float4 spe = SpecularMap.Sample( SpecularSmp, input.TexCoord );
    {
        float3 N = normalize( input.Normal );
        float3 V = normalize( input.WorldPos.xyz - input.CameraPos );
        float3 L = normalize( input.LightDir );

        float3 diffuse   = NormalizedLambert( Diffuse * mapKd.rgb, L, N );
        float3 specular  = NormalizedPhong( Specular * mapKs.rgb, Power, V, N, L );
    #if 1
        output.Color.rgb = ( diffuse.rgb + specular.rgb ) * sdwThreshold;
    #else
        //// fobOp.
        //float4 colors[5] = {
        //    float4( 1.0f, 0.0f, 0.0f, 1.0f ),
        //    float4( 0.0f, 1.0f, 0.0f, 1.0f ),
        //    float4( 0.0f, 0.0f, 1.0f, 1.0f ),
        //    float4( 1.0f, 1.0f, 0.0f, 1.0f ),
        //    float4( 0.0f, 0.0f, 0.0f, 1.0f ),
        //};
        //float4 shadowColor = colors[ index ] * ( 1.0f - sdwThreshold );
        //output.Color.rgb = ( diffuse.rgb + specular.rgb ) + shadowColor.rgb;
    #endif
        output.Color.a   = Alpha;
    }

    return output;
}