﻿//--------------------------------------------------------------------------------
// File : asdxRandom.h
// Desc : Ramdom Number Generater Module
// Copyright(c) Project Asura. All right reserved.
//--------------------------------------------------------------------------------

#ifndef __ASDX_RANDOM_H__
#define __ASDX_RANDOM_H__


//--------------------------------------------------------------------------------
// Includes
//--------------------------------------------------------------------------------
#include <asdxTypedef.h>


namespace asdx {

//////////////////////////////////////////////////////////////////////////////////
// Random class (XorShift)
//////////////////////////////////////////////////////////////////////////////////
class Random
{
    //============================================================================
    // list of friend classes and methods.
    //============================================================================
    /* NOTHING */

private:
    //============================================================================
    // private variables
    //============================================================================
    u32     m_X;            //!< 変数です.
    u32     m_Y;            //!< 変数です.
    u32     m_Z;            //!< 変数です.
    u32     m_W;            //!< 変数です.

    //============================================================================
    // private methods
    //============================================================================
    /* NOTHING */

protected:
    //============================================================================
    // protected variables
    //============================================================================
    /* NOTHING */

    //============================================================================
    // protected methods
    //============================================================================
    /* NOTHING */

public:
    //============================================================================
    // public variables
    //============================================================================
    /* NOTHING */

    //============================================================================
    // public methods
    //============================================================================

    //----------------------------------------------------------------------------
    //! @brief      コンストラクタです.
    //! @param [in]     seed        設定する種.
    //----------------------------------------------------------------------------
    Random ( s32 seed );

    //----------------------------------------------------------------------------
    //! @brief      コピーコンストラクタです.
    //! @param [in]     random      複製元のインスタンス.
    //----------------------------------------------------------------------------
    Random ( const Random& random );

    //----------------------------------------------------------------------------
    //! @brief      デストラクタです.
    //----------------------------------------------------------------------------
    ~Random();

    //----------------------------------------------------------------------------
    //! @brief      ランダム種を設定します.
    //! @param [in]     seed        設定する種.
    //----------------------------------------------------------------------------
    void SetSeed ( s32 seed );

    u32  GetAsU32( void );

    //----------------------------------------------------------------------------
    //! @brief      乱数をs32型として取得します.
    //! @return     -0x80000000から0x7fffffffまでの範囲で乱数を返却します.
    //----------------------------------------------------------------------------
    s32  GetAsS32( void );

    //----------------------------------------------------------------------------
    //! @brief      指定された値範囲までの乱数をs32型として取得します.
    //! @param [in]     a       最大値.
    //! @return     1からaまでの範囲で乱数を返却します.
    //----------------------------------------------------------------------------
    s32  GetAsS32( s32 a );

    //----------------------------------------------------------------------------
    //! @brief      指定された値範囲で乱数をs32型として取得します.
    //! @param [in]     a       最小値.
    //! @param [in]     b       最大値.
    //! @return     aからb-1までの範囲で乱数を返却します.
    //----------------------------------------------------------------------------
    s32  GetAsS32( s32 a, s32 b );

    //----------------------------------------------------------------------------
    //! @brief      乱数をf32型として取得します.
    //! @return     0.0fから1.0fまでの範囲で乱数を返却します.
    //----------------------------------------------------------------------------
    f32  GetAsF32( void );

    //----------------------------------------------------------------------------
    //! @brief      指定された値範囲までの乱数をf32型として取得します.
    //! @param [in]     a       最大値.
    //! @return     0.0fからaまでの範囲で乱数を返却します.
    //----------------------------------------------------------------------------
    f32  GetAsF32( f32 a );

    //----------------------------------------------------------------------------
    //! @brief      指定された値範囲までの乱数をf32型として取得します.
    //! @param [in]     a       最小値.
    //! @param [in]     b       最大値.
    //! @return     aからbまでの範囲で乱数を返却します.
    //----------------------------------------------------------------------------
    f32  GetAsF32( f32 a, f32 b );

    //----------------------------------------------------------------------------
    //! @brief      乱数をf64型として取得します.
    //! @return     0.0から1.0までの範囲で乱数を返却します.
    //----------------------------------------------------------------------------
    f64  GetAsF64( void );

    //----------------------------------------------------------------------------
    //! @brief      指定された値範囲までの乱数をf64型として取得します.
    //! @param [in]     a       最大値.
    //! @return     0.0からaまでの範囲で乱数を返却します.
    //----------------------------------------------------------------------------
    f64  GetAsF64( f64 a );

    //----------------------------------------------------------------------------
    //! @brief      指定された値範囲で乱数をf64型として取得します.
    //! @param [in]     a       最小値.
    //! @param [in]     b       最大値.
    //! @return     aからbまでの範囲で乱数を返却します.
    //----------------------------------------------------------------------------
    f64  GetAsF64( f64 a, f64 b );

    //----------------------------------------------------------------------------
    //! @brief      代入演算子です.
    //
    //! @param [in]     random      代入する値.
    //! @return     代入結果を返却します.
    //----------------------------------------------------------------------------
    Random& operator =  ( const Random& random );

    //----------------------------------------------------------------------------
    //! @brief      等価演算子です.
    //
    //! @param [in]     random      比較する値.
    //! @retval true    等価です.
    //! @retval false   非等価です.
    //----------------------------------------------------------------------------
    bool    operator == ( const Random& random ) const;

    //----------------------------------------------------------------------------
    //! @brief      非等価演算子です.
    //!
    //! @param [in]     random      比較する値.
    //! @retval true    非等価です.
    //! @retval false   等価です.
    //----------------------------------------------------------------------------
    bool    operator != ( const Random& random ) const;
};

} // namespace asura


#endif//__ASDX_RANDOM_H__
