//------------------------------------------------------------------------------------
// File : BasicCompute.hlsl
// Desc : Sample Compute Shader.
// Copyright(c) Project Asura. All right reserved.
//------------------------------------------------------------------------------------

//////////////////////////////////////////////////////////////////////////////////////
// BufType structure
//////////////////////////////////////////////////////////////////////////////////////
struct BufType
{
    int     i;      //!< int̒li[.
    float   f;      //!< float̒li[.
};


///////////////////////////////////////////////////////////////////////////////////////
// CSInput structure
///////////////////////////////////////////////////////////////////////////////////////
struct CSInput
{
    uint3   groupThread  : SV_GroupThreadID;
    uint3   group        : SV_GroupID;
    uint    groupIndex   : SV_GroupIndex;
    uint3   dispatch     : SV_DispatchThreadID;
};


//------------------------------------------------------------------------------------
// Structured Buffers
//------------------------------------------------------------------------------------
StructuredBuffer<BufType>   BufIn0  : register( t0 );       //!< ͗p.
StructuredBuffer<BufType>   BufIn1  : register( t1 );       //!< ͗p.
RWStructuredBuffer<BufType> BufOut  : register( u0 );       //!< o͗p.


#define size_x      32
#define size_y      1
#define size_z      1


//------------------------------------------------------------------------------------
//      Rs[gVF[_̃CGg[|Cgł.
//------------------------------------------------------------------------------------
[numthreads(size_x, size_y, size_z)]
void CSFunc( const CSInput input )
{
    int index = input.dispatch.x;

    // KɉZĂ݂.
    BufOut[ index ].i = BufIn0[ index ].i + BufIn1[ index ].i;
    BufOut[ index ].f = BufIn0[ index ].f * BufIn1[ index ].f;
}


