//----------------------------------------------------------------------------------------
// File : asdxUtil.h
// Desc : Utility Module.
// Copyright(c) Project Asura. All right reserved.
//----------------------------------------------------------------------------------------

#ifndef __ASDX_UTIL_H__
#define __ASDX_UTIL_H__

//----------------------------------------------------------------------------------------
// Includes
//----------------------------------------------------------------------------------------
#include <d3d11.h>


#ifndef SAFE_FREE
#define SAFE_FREE( p )          { free( (p) ); (p) = nullptr; }
#endif//SAFF_FREE 

#ifndef SAFE_DELETE
#define SAFE_DELETE( p )        { if ( (p) ) { delete (p); (p) = nullptr; } }           // if̂operator delete΍̂.
#endif//SAFE_DELETE

#ifndef SAFE_DELETE_ARRAY
#define SAFE_DELETE_ARRAY( p )  { if ( (p) ) { delete [] (p); (p) = nullptr; } }        // if̂operator delete΍̂.
#endif//SAFE_DELETE_ARRAY

#ifndef SAFE_RELEASE
#define SAFE_RELEASE( p )       { if ( (p) ) { (p)->Release(); (p) = nullptr; } }
#endif//SAFE_RELEASE


namespace asdx {

//----------------------------------------------------------------------------------------
//! @brief      fobOIuWFNgݒ肵܂.
//!
//! @param [in]     resource        fobOIuWFNgݒ肷郊\[X.
//! @param [in]     name            ݒ肷fobOIuWFNg.
//----------------------------------------------------------------------------------------
template<UINT TNameLength> inline
void SetDebugObjectName( ID3D11DeviceChild* resource, const char (&name)[TNameLength] )
{
    #if defined(_DEBUG) || defined(DEBUG)
        resource->SetPrivateData(WKPDID_D3DDebugObjectName, TNameLength - 1, name);
    #else
        UNREFERENCED_PARAMETER(resource);
        UNREFERENCED_PARAMETER(name);
    #endif
}

//---------------------------------------------------------------------------------------
//! @brief      @\xΉ镶擾܂.
//!
//! @parma [in]     value       @\x.
//! @return     @\xΉ镶ԋp܂.
//---------------------------------------------------------------------------------------
LPSTR   GetFeatureLevelStringA( const D3D_FEATURE_LEVEL value );

//---------------------------------------------------------------------------------------
//! @brief      @\xΉ镶擾܂.
//!
//! @parma [in]     value       @\x.
//! @return     @\xΉ镶ԋp܂.
//---------------------------------------------------------------------------------------
LPWSTR  GetFeatureLevelStringW( const D3D_FEATURE_LEVEL value );

//---------------------------------------------------------------------------------------
//! @brief      hCo[^CvΉ镶擾܂.
//!
//! @param [in]     value           hCo[^Cv.
//! @return     hCo[^CvΉ镶ԋp܂.
//---------------------------------------------------------------------------------------
LPSTR   GetDriverTypeStringA( const D3D_DRIVER_TYPE value );

//---------------------------------------------------------------------------------------
//! @brief      hCo[^CvΉ镶擾܂.
//!
//! @param [in]     value           hCo[^Cv.
//! @return     hCo[^CvΉ镶ԋp܂.
//---------------------------------------------------------------------------------------
LPWSTR  GetDriverTypeStringW( const D3D_DRIVER_TYPE value );

//---------------------------------------------------------------------------------------
//! @brief      DXGItH[}bgΉ镶擾܂.
//!
//! @param [in]     value           DXGItH[}bg.
//! @return     DXGItH[}bgΉ镶ԋp܂.
//---------------------------------------------------------------------------------------
LPSTR   GetFormatStringA( const DXGI_FORMAT value );

//---------------------------------------------------------------------------------------
//! @brief      DXGItH[}bgΉ镶擾܂.
//!
//! @param [in]     value           DXGItH[}bg.
//! @return     DXGItH[}bgΉ镶ԋp܂.
//---------------------------------------------------------------------------------------
LPWSTR  GetFormatStringW( const DXGI_FORMAT value );

} // namespace asdx

#endif//__ASDX_UTIL_H__

