//--------------------------------------------------------------------------------------------
// File : asdxQuadRenderer.h
// Desc : Asura Quad Renderer Module.
// Copyright(c) Project Asura. All right reserved.
//--------------------------------------------------------------------------------------------

#ifndef __ASDX_QUAD_RENDERER_H__
#define __ASDX_QUAD_RENDERER_H__


//---------------------------------------------------------------------------------------------
// Includes
//---------------------------------------------------------------------------------------------
#include <d3d11.h>
#include <asdxMath.h>


namespace asdx {

///////////////////////////////////////////////////////////////////////////////////////////////
// QuadRenderer class
///////////////////////////////////////////////////////////////////////////////////////////////
class QuadRenderer
{
    //=========================================================================================
    // list of friend classes and methods.
    //=========================================================================================
    /* NOTHING */

private:
    //=========================================================================================
    // private variables.
    //=========================================================================================
    /* NOTHING */

    //=========================================================================================
    // private methods.
    //=========================================================================================
    QuadRenderer    ( const QuadRenderer& value );      // ANZX֎~.
    void operator = ( const QuadRenderer& value );      // ANZX֎~.

protected:
    //=========================================================================================
    // protected varaibles.
    //=========================================================================================
    ID3D11Buffer*       m_pVB;      //!< _obt@ł.
    ID3D11InputLayout*  m_pIL;      //!< ̓CAEgł.


    //=========================================================================================
    // protected methods.
    //=========================================================================================
    /* NOTHING */

public:
    ///////////////////////////////////////////////////////////////////////////////////////////
    // Vertex structure
    //! @brief      _f[^\̂ł.
    ///////////////////////////////////////////////////////////////////////////////////////////
    struct Vertex
    {
        asdx::FLOAT3    Position;       //!< ʒuWł.
        asdx::FLOAT2    TexCoord;       //!< eNX`Wł.
    };

    //=========================================================================================
    // public variables.
    //=========================================================================================
    static const asdx::UINT                 NUM_INPUT_ELEMENT = 2;                      //!< ͗vfł.
    static const D3D11_INPUT_ELEMENT_DESC   INPUT_ELEMENTS[ NUM_INPUT_ELEMENT ];        //!< ͗vfł.

    //=========================================================================================
    // public methods.
    //=========================================================================================

    //-----------------------------------------------------------------------------------------
    //! @brief      RXgN^ł.
    //-----------------------------------------------------------------------------------------
    QuadRenderer();

    //-----------------------------------------------------------------------------------------
    //! @brief      fXgN^ł.
    //-----------------------------------------------------------------------------------------
    virtual ~QuadRenderer();

    //-----------------------------------------------------------------------------------------
    //! @brief      s܂.
    //!
    //! @param [in]     pDevice             foCXł.
    //! @param [in]     pShaderBytecode     VF[_̃oCgR[hł.
    //! @param [in]     byteCodeLength      VF[_̃oCgR[h̒ł.
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //-----------------------------------------------------------------------------------------
    bool Init( 
        ID3D11Device*       pDevice,
        const void*         pShaderBytecode,
        const asdx::UINT    byteCodeLength );

    //-----------------------------------------------------------------------------------------
    //! @brief      Is܂.
    //-----------------------------------------------------------------------------------------
    void Term();

    //-----------------------------------------------------------------------------------------
    //! @brief      `揈s܂.
    //!
    //! @param [in]     pDeviceContext      foCXReLXgł.
    //! @note       ̊֐͓ŁC_obt@Ɠ̓CAEg̐ݒs, `LbN݂̂s܂.
    //!             VF[_⃌_[Xe[g̐ݒ蓙̓AvP[VŐݒ肷Kv܂.
    //-----------------------------------------------------------------------------------------
    void Draw( ID3D11DeviceContext* pDeviceContext );
};

} // namespace asdx

#endif//__ASDX_QUAD_RENDERER_H__
