//--------------------------------------------------------------------------------------------
// File : asdxTexture.h
// Desc : Texture Module.
// Copyright(c) Project Asura. All right reserved.
//--------------------------------------------------------------------------------------------

#ifndef __ASDX_TEXTURE_H__
#define __ASDX_TEXTURE_H__

//---------------------------------------------------------------------------------------------
// Includes
//---------------------------------------------------------------------------------------------
#include <d3d11.h>


namespace asdx {

///////////////////////////////////////////////////////////////////////////////////////////////
// Texture class
///////////////////////////////////////////////////////////////////////////////////////////////
class Texture
{
    //=========================================================================================
    // list of friend classes and methods.
    //=========================================================================================
    /* NOTHING */

public:
    ///////////////////////////////////////////////////////////////////////////////////////////
    // FORMAT enum
    ///////////////////////////////////////////////////////////////////////////////////////////
    enum FORMAT
    {
        FORMAT_INVALID = -1,    //!< ȃtH[}bgł.
        FORMAT_A8 = 0,          //!< A8 tH[}bgł.
        FORMAT_L8,              //!< L8 tH[}bgł.
        FORMAT_R8G8B8A8,        //!< RGBA(8,8,8,8) tH[}bgł.
        FORMAT_BC1,             //!< BC1tH[}bgł.
        FORMAT_BC2,             //!< BC2tH[}bgł.
        FORMAT_BC3,             //!< BC3tH[}bgł.

        NUM_FORMAT              //!< tH[}bgł.
    };

    //=========================================================================================
    // public variables.
    //=========================================================================================
    /* NOTHING */

    //=========================================================================================
    // pubic methods.
    //=========================================================================================

    //-----------------------------------------------------------------------------------------
    //! @brief      RXgN^ł.
    //-----------------------------------------------------------------------------------------
    Texture();

    //-----------------------------------------------------------------------------------------
    //! @brief      fXgN^ł.
    //-----------------------------------------------------------------------------------------
    virtual ~Texture();

    //-----------------------------------------------------------------------------------------
    //! @brief      t@CeNX`𐶐܂.
    //!
    //! @param [in]     pDevice     foCXł.
    //! @param [in]     filename    eNX`t@Cł.
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //-----------------------------------------------------------------------------------------
    bool CreateFromFile( ID3D11Device* pDevice, const char* filename );

    //-----------------------------------------------------------------------------------------
    //! @brief      ł.
    //-----------------------------------------------------------------------------------------
    void Release();

    //-----------------------------------------------------------------------------------------
    //! @brief      tH[}bg擾܂.
    //!
    //! @return     tH[}bgԋp܂.
    //-----------------------------------------------------------------------------------------
    int GetFormat() const;

    //-----------------------------------------------------------------------------------------
    //! @brief      eNX`擾܂.
    //!
    //! @return     eNX`ԋp܂.
    //-----------------------------------------------------------------------------------------
    ID3D11Texture2D*            GetTexture();

    //-----------------------------------------------------------------------------------------
    //! @brief      VF[_\[Xr[擾܂.
    //!
    //! @return     VF[_\[Xr[ԋp܂.
    //-----------------------------------------------------------------------------------------
    ID3D11ShaderResourceView*   GetSRV();

protected:
    //=========================================================================================
    // protected variables
    //=========================================================================================
    int                         m_Format;           //!< tH[}bgł.
    ID3D11Texture2D*            m_pTexture;         //!< eNX`ł.
    ID3D11ShaderResourceView*   m_pSRV;             //!< VF[_\[Xr[ł.

    //=========================================================================================
    // protected methods.
    //=========================================================================================
    /* NOTHING */

private:
    //=========================================================================================
    // private variables.
    //=========================================================================================
    /* NOTHING */

    //=========================================================================================
    // private methods.
    //=========================================================================================
    Texture         ( const Texture& texture );
    void operator = ( const Texture& texture );
};


} // namespace asdx

#endif//__ASDX_TEXTURE_H__
