//---------------------------------------------------------------------------------------
// File : SimpleLayout.fxh
// Desc : Layout of Simple Shader
// Copyright(c) Project Asura. All right reserved.
//---------------------------------------------------------------------------------------

#define PI 3.1415926535f

//---------------------------------------------------------------------------------------
// Structures
//---------------------------------------------------------------------------------------

/////////////////////////////////////////////////////////////////////////////////////////
// VSInput structure
/////////////////////////////////////////////////////////////////////////////////////////
struct VSInput
{
    float3  Position    : POSITION;     //!< ʒuWł.
    float3  Normal      : NORMAL;       //!< @xNgł.
    float3  Tangent     : TANGENT;      //!< ڃxNgł.
    float2  TexCoord    : TEXCOORD;     //!< eNX`Wł.
};


/////////////////////////////////////////////////////////////////////////////////////////
// VSOutput structure
/////////////////////////////////////////////////////////////////////////////////////////
struct VSOutput
{
    float4 Position     : SV_POSITION;  //!< ˉeϊ̈ʒuWł.
    float3 NormalWS     : NORMAL;       //!< [hԂł̖@xNgł.
    float3 TangentWS    : TANGNET;      //!< [hԂł̐ڃxNgł
    float3 BinormalWS   : BINORMAL;     //!< [hԂł̏]@xNgł.
    float2 TexCoord     : TEXCOORD0;    //!< eNX`Wł.
    float3 LightDir     : TEXCOORD1;    //!< CgxNgł.
    float3 ViewDir      : TEXCOORD2;    //!< xNgł.
};


/////////////////////////////////////////////////////////////////////////////////////////
// PSOutput structure
/////////////////////////////////////////////////////////////////////////////////////////
struct PSOutput
{
    float4 Color0       : SV_TARGET0;       //!< J[0ł.
};


//---------------------------------------------------------------------------------------
// Constant Buffers
//---------------------------------------------------------------------------------------

/////////////////////////////////////////////////////////////////////////////////////////
// Material Buffer
/////////////////////////////////////////////////////////////////////////////////////////
cbuffer Material : register( b0 )
{
    float3 Diffuse  : packoffset( c0 );     //!< gUːFł.
    float  Alpha    : packoffset( c0.w );   //!< ߓxł.
    float3 Specular : packoffset( c1 );     //!< ʔːFł.
    float  Power    : packoffset( c1.w );   //!< ʔˋxł.
    float3 Emissive : packoffset( c2 );     //!< ȏƖFł.
    float  Bump     : packoffset( c2.w );   //!< ov}bsOtO.
};


/////////////////////////////////////////////////////////////////////////////////////////
// TransformParam Buffer
/////////////////////////////////////////////////////////////////////////////////////////
cbuffer TransformParam : register( b1 )
{
    float4x4 World  : packoffset( c0 );     //!< [hsł.
    float4x4 View   : packoffset( c4 );     //!< r[sł.
    float4x4 Proj   : packoffset( c8 );     //!< ˉesł.
    float4   Light  : packoffset( c12 );     //!< Cgł(w=0̏ꍇ́C, w=1̏ꍇ͓_).
};

Texture2D       DiffuseMap    : register( t0 );
Texture2D       SpecularMap   : register( t1 );
Texture2D       BumpMap       : register( t2 );
SamplerState    DiffuseSmp    : register( s0 );
SamplerState    SpecularSmp   : register( s1 );
SamplerState    BumpSmp       : register( s2 );

//---------------------------------------------------------------------------------------
// Functions
//---------------------------------------------------------------------------------------

//---------------------------------------------------------------------------------------
//! @brief      r[s񂩂王xNg擾܂.
//!
//! @param [in]     view        r[s.
//! @return xNgԋp܂.
//! @note   1s3ڂ ( CameraPosition.x - CameraTarget.x )
//!         2s3ڂ ( CameraPosition.y - CameraTarget.y )
//!         3s3ڂ ( CameraPosition.z - CameraTarget.z )
//!         łƁC肵ɂȂĂ܂.
//---------------------------------------------------------------------------------------
float3 GetViewDir( float4x4 view )
{
    return normalize( float3( -view._13, -view._23, -view._33 ) );
}

//---------------------------------------------------------------------------------------
//! @brief      o[gCeBOs܂.
//!
//! @param [in]     diffuse     gUːF.
//! @param [in]     lightDir    CgxNg.
//! @param [in]     normal      @xNg.
//! @return     o[gCeBOʂԋp܂.
//---------------------------------------------------------------------------------------
float3 Lambert( float3 diffuse, float3 lightDir, float3 normal )
{
    return diffuse * max( dot( normal, lightDir ), 0.0f );
}

//---------------------------------------------------------------------------------------
//! @brief      tHCeBOs܂.
//!
//! @param [in]     specular    ʔːF.
//! @param [in]     power       ʔˋx.
//! @param [in]     viewDir     xNg.
//! @param [in]     normal      @xNg.
//! @parma [in]     lightDir    CgxNg.
//! @return     tHCeBǑʂԋp܂.
//---------------------------------------------------------------------------------------
float3 Phong( float3 specular, float power, float3 viewDir, float3 normal, float3 lightDir )
{
    float3 R = -viewDir + ( 2.0f * dot( normal, viewDir ) * normal );

    return specular * pow( max ( dot( lightDir, R ), 0.0f ), power );
}
