//------------------------------------------------------------------------------
// File : SampleApp.h
// Desc : Sample Application.
// Copyright(c) Project Asura. All right reserved.
//------------------------------------------------------------------------------

#ifndef __SAMPLE_APP_H__
#define __SAMPLE_APP_H__

//------------------------------------------------------------------------------
// Include
//------------------------------------------------------------------------------
#include <asdxApp.h>
#include <asdxResMesh.h>
#include <asdxMesh.h>
#include <asdxCameraUpdater.h>
#include <asdxAxisRenderer.h>
#include <asdxFont.h>


/////////////////////////////////////////////////////////////////////////////////////////
// TrasnsformParam structure
/////////////////////////////////////////////////////////////////////////////////////////
struct TransformParam
{
    asdx::MATRIX    World;          //!< [hs.
    asdx::MATRIX    View;           //!< r[s.
    asdx::MATRIX    Proj;           //!< ˉes.
    asdx::FLOAT4    Light;          //!< Cg.
};


////////////////////////////////////////////////////////////////////////////////////////
// SampleApplication
////////////////////////////////////////////////////////////////////////////////////////
class SampleApplication : public asdx::Application
{
    //==================================================================================
    // list of friend classes and methods.
    //==================================================================================
    /* NOTHING */

private:
    //===================================================================================
    // private variables.
    //===================================================================================
    asdx::Font                  m_Font;             //!< tHgł.
    asdx::CameraUpdater         m_Camera;           //!< Jł.
    ID3D11Buffer*               m_pTB;              //!< ϊp[^obt@ł.
    ID3D11VertexShader*         m_pVS;              //!< _VF[_ł.
    ID3D11PixelShader*          m_pPS;              //!< sNZVF[_ł.
    TransformParam              m_TransformParam;   //!< ϊp[^ł.
    asdx::Mesh                  m_Dosei;            //!< ǂ.
    asdx::Mesh                  m_Ground;           //!< n.
    asdx::AxisRenderer          m_AxisRenderer;

    //==================================================================================
    // private methods.
    //==================================================================================

    //----------------------------------------------------------------------------------
    //! @brief      eLXg`掞̏ł.
    //----------------------------------------------------------------------------------
    void OnDrawText();

    //----------------------------------------------------------------------------------
    //! @brief      bV`掞̏ł.
    //----------------------------------------------------------------------------------
    void OnDrawMesh();

protected:
    //==================================================================================
    // protected varaibles
    //==================================================================================
    /* NOTHING */

    //==================================================================================
    // protected methods.
    //==================================================================================

    //----------------------------------------------------------------------------------
    //! @brief      ̏ł.
    //!
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //----------------------------------------------------------------------------------
    bool OnInit();

    //----------------------------------------------------------------------------------
    //! @brief      Ȉł.
    //----------------------------------------------------------------------------------
    void OnTerm();

    //----------------------------------------------------------------------------------
    //! @brief      t[@ێ̏ł.
    //!
    //! @param [in]     time            AvP[VJnĂ̑ΎԂł.
    //! @param [in]     elapsedTime     Ot[̌oߎԂł.
    //----------------------------------------------------------------------------------
    void OnFrameMove  ( double time, double elapsedTime );

    //----------------------------------------------------------------------------------
    //! @brief      t[`掞̏ł.
    //!
    //! @param [in]     time            AvP[VJnĂ̑ΎԂł.
    //! @param [in]     elapsedTime     Ot[̌oߎԂł.
    //----------------------------------------------------------------------------------
    void OnFrameRender( double time, double elapsedTime );

    //----------------------------------------------------------------------------------
    //! @brief      TCY̏ł.
    //!
    //! @param [in]     param           TCYCxgp[^ł.
    //----------------------------------------------------------------------------------
    void OnResize     ( const asdx::ResizeEventParam& param );

    //----------------------------------------------------------------------------------
    //! @brief      L[Cxg̏ł.
    //!
    //! @param [in]     param           L[Cxgp[^ł.
    //----------------------------------------------------------------------------------
    void OnKey        ( const asdx::KeyEventParam& param );

    //----------------------------------------------------------------------------------
    //! @brief      }EXCxg̏ł.
    //!
    //! @param [in]     param           }EXCxgp[^ł.
    //----------------------------------------------------------------------------------
    void OnMouse      ( const asdx::MouseEventParam& param );

public:
    //==================================================================================
    // public variables.
    //==================================================================================
    /* NOTHING */

    //==================================================================================
    // public methods.
    //==================================================================================

    //----------------------------------------------------------------------------------
    //! @brief      RXgN^ł.
    //----------------------------------------------------------------------------------
    SampleApplication();

    //----------------------------------------------------------------------------------
    //! @brief      fXgN^ł.
    //----------------------------------------------------------------------------------
    virtual ~SampleApplication();
};



#endif//__SAMPLE_APP_H__
