//----------------------------------------------------------------------------------------------
// File : asdxFont.h
// Desc : Font Module.
// Copyright(c) Project Asura. All right reserved.
//----------------------------------------------------------------------------------------------

#ifndef __ASDX_FONT_H__
#define __ASDX_FONT_H__

//----------------------------------------------------------------------------------------------
// Includes
//----------------------------------------------------------------------------------------------
#include <d3d11.h>
#include <asdxMath.h>


namespace asdx {

////////////////////////////////////////////////////////////////////////////////////////////////
// Font class
////////////////////////////////////////////////////////////////////////////////////////////////
class Font
{
    //==========================================================================================
    // list of friend classes and methods.
    //==========================================================================================
    /* NOTHING */

private:
    //==========================================================================================
    // private variables.
    //==========================================================================================
    /* NOTHING */

    //==========================================================================================
    // private methods.
    //==========================================================================================
    /* NOTHING */

protected:
    ////////////////////////////////////////////////////////////////////////////////////////////
    // Vertex structure
    ////////////////////////////////////////////////////////////////////////////////////////////
    struct Vertex
    {
        asdx::FLOAT3    Position;       //!< ʒuWł.
        asdx::FLOAT4    Color;          //!< _J[ł.
        asdx::FLOAT2    TexCoord;       //!< eNX`Wł.
    };

    //==========================================================================================
    // protected variables.
    //==========================================================================================
    static const size_t                     InputElementCount = 3;              //!< ͗vfł.
    static const D3D11_INPUT_ELEMENT_DESC   InputElements[ InputElementCount ]; //!< ͗vfł.
    static const size_t NUM_SPRITES           = 2048;   //!< őXvCgł.
    static const size_t NUM_VERTEX_PER_SPRITE = 4;      //!< 1XvCg̒_ł.
    static const size_t NUM_INDEX_PER_SPRITE  = 6;      //!< 1XvCg̃CfbNXł.

    ID3D11VertexShader*         m_pVS;          //!< _VF[_ł.
    ID3D11PixelShader*          m_pPS;          //!< sNZVF[_ł.
    ID3D11InputLayout*          m_pIL;          //!< ̓CAEgł.
    ID3D11Buffer*               m_pVB;          //!< _obt@ł.
    ID3D11Buffer*               m_pIB;          //!< CfbNXobt@ł.
    ID3D11Buffer*               m_pCB;          //!< 萔obt@ł.
    ID3D11Texture2D*            m_pTexture;     //!< eNX`ł.
    ID3D11ShaderResourceView*   m_pSRV;         //!< VF[_\[Xr[ł.
    ID3D11SamplerState*         m_pSmp;         //!< Tv[Xe[gł.
    ID3D11BlendState*           m_pBS;          //!< uhXe[gł.
    ID3D11DepthStencilState*    m_pDSS;         //!< [xXeVXe[gł.
    ID3D11RasterizerState*      m_pRS;          //!< X^CU[Xe[gł.

    unsigned int    m_SpriteCount;              //!< XvCgł.
    unsigned int    m_FontWidth;                //!< tHg̉ł.
    unsigned int    m_FontHeight;               //!< tHg̏cł.
    char            m_FontName[ 32 ];           //!< tHgł.
    float           m_OffsetU;                  //!< ŨItZbgł.
    float           m_OffsetV;                  //!< ṼItZbgł.
    asdx::FLOAT2    m_ScreenSize;               //!< XN[TCYł.
    asdx::FLOAT4    m_Color;                    //!< eLXgJ[ł.
    asdx::MATRIX    m_Transform;                //!< ϊsł.
    char            m_Buffer[ NUM_SPRITES ];    //!< obt@ł.
    Vertex          m_Vertices[ NUM_SPRITES * NUM_VERTEX_PER_SPRITE ];  //!< _f[^ł.

    //==========================================================================================
    // protected methods.
    //==========================================================================================
    /* NOTHING */

public:
    //==========================================================================================
    // public variables.
    //==========================================================================================
    /* NOTHING */

    //==========================================================================================
    // public methods.
    //==========================================================================================

    //------------------------------------------------------------------------------------------
    //! @brief      RXgN^ł.
    //------------------------------------------------------------------------------------------
    Font();

    //------------------------------------------------------------------------------------------
    //! @brief      fXgN^ł.
    //------------------------------------------------------------------------------------------
    virtual ~Font();

    //------------------------------------------------------------------------------------------
    //! @brief      ł.
    //!
    //! @param [in]     pDevice         foCXł.
    //! @param [in]     filename        tHgoCit@Cł.
    //! @param [in]     screenWidth     XN[̉ł.
    //! @param [in]     screenHeight    XN[̏cł.
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //------------------------------------------------------------------------------------------
    bool Init( ID3D11Device* pDevice, const char* filename, float screenWidth, float screenHeight );

    //------------------------------------------------------------------------------------------
    //! @brief      Ił.
    //------------------------------------------------------------------------------------------
    void Term();

    //------------------------------------------------------------------------------------------
    //! @brief      XN[TCYݒ肵܂.
    //!
    //! @param [in]     width       XN[̉.
    //! @param [in]     height      XN[̏c.
    //------------------------------------------------------------------------------------------
    void SetScreenSize( float width, float height );

    //------------------------------------------------------------------------------------------
    //! @brief      XN[TCYݒ肵܂.
    //!
    //! @param [in]     size        ݒ肷TCY.
    //------------------------------------------------------------------------------------------
    void SetScreenSize( const asdx::FLOAT2& size );

    //------------------------------------------------------------------------------------------
    //! @brief      eLXgJ[ݒ肵܂.
    //!
    //! @param [in]     r       Rł.
    //! @param [in]     g       Gł.
    //! @param [in]     b       Bł.
    //! @param [in]     a       Ał.
    //------------------------------------------------------------------------------------------
    void SetColor( float r, float g, float b, float a );

    //------------------------------------------------------------------------------------------
    //! @brief      eLXgJ[ݒ肵܂.
    //!
    //! @param [in]     color       ݒ肷J[.
    //------------------------------------------------------------------------------------------
    void SetColor( const asdx::FLOAT4& color );

    //------------------------------------------------------------------------------------------
    //! @brief      `Jn܂.
    //------------------------------------------------------------------------------------------
    void Begin( ID3D11DeviceContext* pDeviceContext );

    //------------------------------------------------------------------------------------------
    //! @brief      `悵܂.
    //!
    //! @param [in]     x       `JnXW.
    //! @param [in]     y       `JnYW.
    //! @param [in]     text    `悷eLXg.
    //------------------------------------------------------------------------------------------
    void DrawString( const int x, const int y, const char* text );

    //------------------------------------------------------------------------------------------
    //! @brief      `悵܂.
    //!
    //! @param [in]     x           `JnXW.
    //! @param [in]     y           `JnYW.
    //! @param [in]     layerDepth  C[̐[.
    //! @param [in]     text        `悷eLXg.
    //------------------------------------------------------------------------------------------
    void DrawString( const int x, const int y, const int layerDepth, const char* text );

    //------------------------------------------------------------------------------------------
    //! @brief      `悵܂.
    //!
    //! @param [in]     x           `JnXW.
    //! @param [in]     y           `JnYW.
    //! @param [in]     format      wq.
    //! @param [in]     ...         ψ.
    //------------------------------------------------------------------------------------------
    void DrawStringArg( const int x, const int y, const char* format, ... );

    //------------------------------------------------------------------------------------------
    //! @brief      `悵܂.
    //!
    //! @param [in]     x           `JnXW.
    //! @param [in]     y           `JnYW.
    //! @param [in]     layerDepth  C[̐[.
    //! @param [in]     format      wq.
    //! @param [in]     ...         ψ.
    //------------------------------------------------------------------------------------------
    void DrawStringArg( const int x, const int y, const int layerDepth, const char* format, ... );

    //------------------------------------------------------------------------------------------
    //! @brief      `Ił.
    //!
    //! @param [in]     pDeviceContext      foCXReLXg.
    //------------------------------------------------------------------------------------------
    void End( ID3D11DeviceContext* pDeviceContext );

    //------------------------------------------------------------------------------------------
    //! @brief      tHg̉擾܂.
    //!
    //! @return     tHg̉ԋp܂.
    //------------------------------------------------------------------------------------------
    unsigned int GetFontWidth () const;

    //------------------------------------------------------------------------------------------
    //! @brief      tHg̏c擾܂.
    //!
    //! @return     tHg̏cԋp܂.
    //------------------------------------------------------------------------------------------
    unsigned int GetFontHeight() const;

    //------------------------------------------------------------------------------------------
    //! @brief      tHg擾܂.
    //!
    //! @return     tHgԋp܂.
    //------------------------------------------------------------------------------------------
    char*        GetFontName  () const;

    //------------------------------------------------------------------------------------------
    //! @brief      ݒ肳ĂXN[TCY擾܂.
    //!
    //! @return     ݒ肳ĂXN[TCYԋp܂.
    //------------------------------------------------------------------------------------------
    asdx::FLOAT2 GetScreenSize() const;

    //------------------------------------------------------------------------------------------
    //! @brief      ݒ肳ĂeLXgJ[擾܂.
    //!
    //! @return     ݒ肳ĂeLXgJ[ԋp܂.
    //------------------------------------------------------------------------------------------
    asdx::FLOAT4 GetColor() const;
};

} // namespace asdx

#endif//__ASDX_FONT_H__
