//-------------------------------------------------------------------------------------------
// File : asdxCamera.h
// Desc : Camera Module.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------

#ifndef __ASDX_CAMERA_H__
#define __ASDX_CAMERA_H__

//-------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------
#include <asdxMath.h>


namespace asdx {

/////////////////////////////////////////////////////////////////////////////////////////////
// CameraEvent struct
/////////////////////////////////////////////////////////////////////////////////////////////
struct CameraEvent
{
    /////////////////////////////////////////////////////////////////////////////////////////
    // EVENT_TYPE enum
    /////////////////////////////////////////////////////////////////////////////////////////
    enum EVENT_TYPE
    {
        EVENT_ROTATE  = 0x000001 << 0,     //!< ^[Qbg𒆐Sɉ].
        EVENT_DOLLY   = 0x000001 << 1,     //!< h[.
        EVENT_TRUCK   = 0x000001 << 2,     //!< sړ.
        EVENT_TWIST   = 0x000001 << 3,     //!< cCXg.
        EVENT_PANTILT = 0x000001 << 4,     //!< pE`g.
        EVENT_RESET   = 0x000001 << 5,     //!< Zbg.
    };

    asdx::FLOAT2    Rotate;     //!< ]pł.
    asdx::FLOAT2    PanTilt;    //!< pE`gp.
    asdx::FLOAT3    Truck;      //!< gbNʂł.
    float           Twist;      //!< cCXgpł.
    float           Dolly;      //!< h[ʂł.
    unsigned int    Flags;      //!< tOł.

    //---------------------------------------------------------------------------------------
    //! @brief      RXgN^ł.
    //---------------------------------------------------------------------------------------
    CameraEvent()
    : Rotate    ( 0.0f, 0.0f )
    , PanTilt   ( 0.0f, 0.0f )
    , Truck     ( 0.0f, 0.0f, 0.0f )
    , Twist     ( 0.0f )
    , Dolly     ( 0.0f )
    , Flags     ( 0 )
    { /* DO_NOTHING */ }
};


/////////////////////////////////////////////////////////////////////////////////////////////
// Camera class
/////////////////////////////////////////////////////////////////////////////////////////////
class Camera
{
    //=======================================================================================
    // list of friend classes and methods.
    //=======================================================================================
    /* NOTHING */

public:
    //=======================================================================================
    // public variables
    //=======================================================================================
    struct Param
    {
        asdx::FLOAT3 Position;      //!< J̈ʒuł.
        asdx::FLOAT3 Target;        //!< J̒_ł.
        asdx::FLOAT3 Upward;        //!< J̏xNgł.
        asdx::FLOAT2 Rotate;        //!< ]pł.
        asdx::FLOAT2 PanTilt;       //!< pE`gpł.
        float        Twist;         //!< cCXgpł.
        float        MinDist;       //!< ^[QbgƂ̍ŏł.
        float        MaxDist;       //!< ^[QbgƂ̍ő勗ł.

        //-----------------------------------------------------------------------------------
        //! @brief      RXgN^ł.
        //-----------------------------------------------------------------------------------
        Param()
        : Position  ( 0.0f, 0.0f, 5.0f )
        , Target    ( 0.0f, 0.0f, 0.0f )
        , Upward    ( 0.0f, 1.0f, 0.0f )
        , Rotate    ( 0.0f, 0.0f )
        , PanTilt   ( 0.0f, 0.0f )
        , Twist     ( 0.0f )
        , MinDist   ( 0.01f )
        , MaxDist   ( 1000.0f )
        { /* DO_NOTHING */ }
    };

    //=======================================================================================
    // public methods.
    //=======================================================================================

    //---------------------------------------------------------------------------------------
    //! @brief      RXgN^ł.
    //---------------------------------------------------------------------------------------
    Camera();

    //---------------------------------------------------------------------------------------
    //! @brief      fXgN^ł.
    //---------------------------------------------------------------------------------------
    ~Camera();

    //---------------------------------------------------------------------------------------
    //! @brief      Jʒuݒ肵܂.
    //!
    //! @param [in]     position        ݒ肷Jʒuł.
    //---------------------------------------------------------------------------------------
    void SetPosition( const asdx::FLOAT3& position );

    //---------------------------------------------------------------------------------------
    //! @brief      J_ݒ肵܂.
    //!
    //! @param [in]     target          ݒ肷J_ł.
    //---------------------------------------------------------------------------------------
    void SetTarget( const asdx::FLOAT3& target );

    //---------------------------------------------------------------------------------------
    //! @brief      JxNgݒ肵܂.
    //!
    //! @param [in]     upward          ݒ肷JxNgł.
    //---------------------------------------------------------------------------------------
    void SetUpward( const asdx::FLOAT3& upward );

    //---------------------------------------------------------------------------------------
    //! @brief      cCXgpݒ肵܂.
    //!
    //! @param [in]     twist           ݒ肷cCXgpł.
    //---------------------------------------------------------------------------------------
    void SetTwist( const float twist );

    //---------------------------------------------------------------------------------------
    //! @brief      ͈͂ݒ肵܂.
    //!
    //! @param [in]     minDist         ݒ肷J_Ƃ̍ŏ.
    //! @param [in]     maxDist         ݒ肷J_Ƃ̍ő勗.
    //---------------------------------------------------------------------------------------
    void SetRange( const float minDist, const float maxDist );

    //---------------------------------------------------------------------------------------
    //! @brief      Jp[^L܂.
    //---------------------------------------------------------------------------------------
    void Preset();

    //---------------------------------------------------------------------------------------
    //! @brief      Jp[^Zbg܂.
    //---------------------------------------------------------------------------------------
    void Reset();

    //---------------------------------------------------------------------------------------
    //! @brief      r[sXV܂.
    //---------------------------------------------------------------------------------------
    void Update();

    //---------------------------------------------------------------------------------------
    //! @brief      JCxgɃr[sXV܂.
    //---------------------------------------------------------------------------------------
    void UpdateByEvent( const CameraEvent& camEvent );

    //---------------------------------------------------------------------------------------
    //! @brief      r[s擾܂.
    //!
    //! @return     r[sԋp܂.
    //---------------------------------------------------------------------------------------
    asdx::MATRIX GetView() const;

    //---------------------------------------------------------------------------------------
    //! @brief      Jʒu擾܂.
    //!
    //! @return     Jʒuԋp܂.
    //---------------------------------------------------------------------------------------
    asdx::FLOAT3 GetPosition() const;

    //---------------------------------------------------------------------------------------
    //! @brief      J_擾܂.
    //!
    //! @return     J_ԋp܂.
    //---------------------------------------------------------------------------------------
    asdx::FLOAT3 GetTarget() const;

    //---------------------------------------------------------------------------------------
    //! @brief      JxNg擾܂.
    //!
    //! @return     JxNgԋp܂.
    //---------------------------------------------------------------------------------------
    asdx::FLOAT3 GetUpward() const;

    //---------------------------------------------------------------------------------------
    //! @brief      cCXgp擾܂.
    //!
    //! @return     cCXgpԋp܂.
    //---------------------------------------------------------------------------------------
    float GetTwist() const;

    //---------------------------------------------------------------------------------------
    //! @brief      ŏ(J_Ƃ̍ŏ)擾܂.
    //!
    //! @return     ŏԋp܂.
    //---------------------------------------------------------------------------------------
    float GetMinDist() const;

    //---------------------------------------------------------------------------------------
    //! @brief      ő勗(J_Ƃ̍ő勗)擾܂.
    //!
    //! @return     ő勗ԋp܂.
    //---------------------------------------------------------------------------------------
    float GetMaxDist() const;


protected:
    //=======================================================================================
    // protected variables.
    //=======================================================================================
    /* NOTHING */

    //=======================================================================================
    // protected methods.
    //=======================================================================================
    /* NOTHING */


private:
    //=======================================================================================
    // private variables
    //=======================================================================================
    Param           m_Param;        //!< vZpJp[^ł.
    Param           m_Preset;       //!< ZbgpJp[^ł.
    asdx::MATRIX    m_View;         //!< r[sł.

    //=======================================================================================
    // praviate methods.
    //=======================================================================================

    //---------------------------------------------------------------------------------------
    //! @brief      pxvZ܂.
    //---------------------------------------------------------------------------------------
    void ComputeAngle();

    //---------------------------------------------------------------------------------------
    //! @brief      ͈͓ɐ܂.
    //---------------------------------------------------------------------------------------
    void ClampDist();
};


} // namespace asdx

#endif//__ASDX_CAMERA_H__
