//---------------------------------------------------------------------------------------------
// File : asdxApp.h
// Desc : Application Module.
// Copyright(c) Project Asura. All right reserved.
//---------------------------------------------------------------------------------------------

#ifndef __ASDX_APP_H__
#define __ASDX_APP_H__

//---------------------------------------------------------------------------------------------
// Includes
//---------------------------------------------------------------------------------------------
#include <d3d11.h>
#include <dxgi.h>
#include <Windows.h>
#include <DirectXMath.h>
#include <DirectXColors.h>
#include <asdxRenderTarget.h>
#include <asdxDepthBuffer.h>
#include <asdxMath.h>
#include <asdxTimer.h>


//---------------------------------------------------------------------------------------------
// Linker
//---------------------------------------------------------------------------------------------
#ifdef ASDX_AUTO_LINK
#pragma comment( lib, "d3d11.lib" )
#pragma comment( lib, "d3dcompiler.lib" )
#pragma comment( lib, "dxguid.lib" )
#pragma comment( lib, "winmm.lib" )
#pragma comment( lib, "comctl32.lib" )
#endif//ASDX_AUTO_LINK


//---------------------------------------------------------------------------------------------
// Macro
//---------------------------------------------------------------------------------------------
#ifndef ASDX_UNUSED_VAR
#define ASDX_UNUSED_VAR( x )        ((void)x)
#endif//ASDX_UNUSED_VAR


namespace asdx {

//////////////////////////////////////////////////////////////////////////////////////////////
// MouseEventParam structure
//////////////////////////////////////////////////////////////////////////////////////////////
struct MouseEventParam
{
    int     X;                  //!< J[\XWł.
    int     Y;                  //!< J[\YWł.
    int     WheelDelta;         //!< }EXzC[̈ړł.
    bool    IsLeftButtonDown;   //!< {^ꂽǂtOł.
    bool    IsRightButtonDown;  //!< E{^ꂽǂtOł.
    bool    IsMiddleButtonDown; //!< {^ꂽǂtOł.
    bool    IsSideButton1Down;  //!< X1{^ꂽǂtOł.
    bool    IsSideButton2Down;  //!< X2{^ꂽǂtOł.

    //-----------------------------------------------------------------------------------------
    //! @brief      RXgN^ł.
    //-----------------------------------------------------------------------------------------
    MouseEventParam()
    : X                 ( 0 )
    , Y                 ( 0 )
    , WheelDelta        ( 0 )
    , IsLeftButtonDown  ( false )
    , IsRightButtonDown ( false)
    , IsMiddleButtonDown( false )
    , IsSideButton1Down ( false )
    , IsSideButton2Down ( false )
    { /* DO_NOTHING */ }
};


//////////////////////////////////////////////////////////////////////////////////////////////
// KeyEventParam structure
//////////////////////////////////////////////////////////////////////////////////////////////
struct KeyEventParam
{
    UINT    KeyCode;        //!< L[R[hł.
    bool    IsKeyDown;      //!< L[ꂽǂtOł.
    bool    IsAltDown;      //!< ALTL[ꂽǂtOł.

    //----------------------------------------------------------------------------------------
    //! @brief      RXgN^ł.
    //----------------------------------------------------------------------------------------
    KeyEventParam()
    : KeyCode   ( 0 )
    , IsKeyDown ( false )
    , IsAltDown ( false )
    { /* DO_NOTHING */ }
};


//////////////////////////////////////////////////////////////////////////////////////////////
// ResizeEvent structure
//////////////////////////////////////////////////////////////////////////////////////////////
struct ResizeEventParam
{
    UINT    Width;          //!< ʂ̉ł.
    UINT    Height;         //!< ʂ̏cł.
    FLOAT   AspectRatio;    //!< ʂ̃AXyNgł.

    //----------------------------------------------------------------------------------------
    //! @brief      RXgN^ł.
    //----------------------------------------------------------------------------------------
    ResizeEventParam()
    : Width      ( 0 )
    , Height     ( 0 )
    , AspectRatio( 0.0f )
    { /* DO_NOTHING */ }
};


//////////////////////////////////////////////////////////////////////////////////////////////
// Application class
//////////////////////////////////////////////////////////////////////////////////////////////
class Application
{
    //========================================================================================
    // list of friend classes and methods.
    //========================================================================================
    /* NOTHING */

public:
    //========================================================================================
    // public variables.
    //========================================================================================
    /* NOTHING */

    //========================================================================================
    // public methods.
    //========================================================================================

    //----------------------------------------------------------------------------------------
    //! @brief      RXgN^ł.
    //----------------------------------------------------------------------------------------
    Application();

    //----------------------------------------------------------------------------------------
    //! @brief      tRXgN^ł.
    //!
    //! @param [in]     title       ^Cg.
    //----------------------------------------------------------------------------------------
    Application( LPSTR title );

    //----------------------------------------------------------------------------------------
    //! @brief      fXgN^ł.
    //----------------------------------------------------------------------------------------
    virtual ~Application();

    //----------------------------------------------------------------------------------------
    //! @brief      AvP[Vs܂.
    //----------------------------------------------------------------------------------------
    void    Run();

protected:
    //========================================================================================
    // protected variables
    //========================================================================================
    HINSTANCE                   m_hInst;                //!< CX^Xnhł.
    HWND                        m_hWnd;                 //!< EBhEnhł.
    D3D_DRIVER_TYPE             m_DriverType;           //!< hCo[^Cvł.
    D3D_FEATURE_LEVEL           m_FeatureLevel;         //!< @\xł.
    UINT                        m_MultiSampleCount;     //!< }`TvÕJEgł.
    UINT                        m_MultiSampleQuality;   //!< }`TvO̕ilł.
    UINT                        m_SwapChainCount;       //!< Xbv`FC̃obt@ł.
    DXGI_FORMAT                 m_SwapChainFormat;      //!< Xbv`FC̃obt@tH[}bgł.
    DXGI_FORMAT                 m_DepthStencilFormat;   //!< [xXeVobt@̃tH[}bgł.
    ID3D11Device*               m_pDevice;              //!< foCXł.
    ID3D11DeviceContext*        m_pDeviceContext;       //!< foCXReLXg(C~fBGCgReLXg)ł.
    IDXGISwapChain*             m_pSwapChain;           //!< Xbv`FCł.
    RenderTarget2D              m_RenderTarget2D;       //!< `^[Qbgł.
    DepthStencilBuffer          m_DepthStencilBuffer;   //!< [xXeVobt@ł.
    ID3D11RasterizerState*      m_pRasterizerState;     //!< X^CU[Xe[gł.
    ID3D11DepthStencilState*    m_pDepthStencilState;   //!< [xXeVXe[gł.
    ID3D11BlendState*           m_pBlendState;          //!< uhXe[gł.
    FLOAT                       m_BlendFactor[ 4 ];     //!< uht@N^[ł.
    UINT                        m_SampleMask;           //!< Tv}XNł.
    UINT                        m_StencilRef;           //!< XeVQƂł.
    FLOAT4                      m_ClearColor;           //!< wĩNAJ[ł.
    UINT                        m_Width;                //!< ʂ̉ł.
    UINT                        m_Height;               //!< ʂ̏cł.
    FLOAT                       m_AspectRatio;          //!< ʂ̃AXyNgł.
    LPSTR                       m_Title;                //!< AvP[Ṽ^Cgł.
    Timer                       m_Timer;                //!< ^C}[ł.


    //========================================================================================
    // protected methods.
    //========================================================================================
    
    //----------------------------------------------------------------------------------------
    //! @brief      Ɏs鏈ł.
    //!
    //! @note       hNXɂĎs܂.
    //----------------------------------------------------------------------------------------
    virtual bool OnInit       ();

    //----------------------------------------------------------------------------------------
    //! @brief      IɎs鏈ł.
    //!
    //! @note       hNXɂĎs܂.
    //----------------------------------------------------------------------------------------
    virtual void OnTerm       ();

    //----------------------------------------------------------------------------------------
    //! @brief      t[JڎɎs鏈ł.
    //!
    //! @param [in]     time        AvP[VJn̑ΎԂł.
    //! @param [in]     elapsedTime Õt[oߎԂł.
    //! @note       hNXɂĎs܂.
    //----------------------------------------------------------------------------------------
    virtual void OnFrameMove  ( double time, double elapsedTime );

    //----------------------------------------------------------------------------------------
    //! @brief      t[`掞Ɏs鏈ł.
    //!
    //! @param [in]     time        AvP[VJn̑ΎԂł.
    //! @param [in]     elapsedTime Õt[̌oߎԂł.
    //! @note       hNXɂĎs܂.
    //----------------------------------------------------------------------------------------
    virtual void OnFrameRender( double time, double elapsedTime );

    //----------------------------------------------------------------------------------------
    //! @brief      TCYɎs鏈ł.
    //!
    //! @param [in]     param       TCYCxgp[^ł.
    //! @note       hNXɂĎs܂.
    //----------------------------------------------------------------------------------------
    virtual void OnResize     ( const ResizeEventParam& param );

    //----------------------------------------------------------------------------------------
    //! @brief      L[CxgʒmɎs鏈ł.
    //!
    //! @param [in]     param       L[Cxgp[^ł.
    //! @note       hNXɂĎs܂.
    //----------------------------------------------------------------------------------------
    virtual void OnKey        ( const KeyEventParam&    param );

    //----------------------------------------------------------------------------------------
    //! @brief      }EXCxgʒmɎs鏈ł.
    //!
    //! @param [in]     param       }EXCxgp[^ł.
    //! @note       hNXɂĎs܂.
    //----------------------------------------------------------------------------------------
    virtual void OnMouse      ( const MouseEventParam&  param );

    //----------------------------------------------------------------------------------------
    //! @brief      `~tOݒ肵܂.
    //!
    //! @param [in]     isStopRendering     `~邩ǂ.~ꍇtruew肵܂.
    //----------------------------------------------------------------------------------------
    void SetStopRendering( bool isStopRendering );

    //----------------------------------------------------------------------------------------
    //! @brief      `~tO擾܂.
    //!
    //! @retval true    `揈Ăяo܂.
    //! @retval false   `揈Ăяo܂.
    //----------------------------------------------------------------------------------------
    bool IsStopRendering() const;

    //----------------------------------------------------------------------------------------
    //! @brief      t[JEg擾܂.
    //!
    //! @return     t[JEgԋp܂.
    //----------------------------------------------------------------------------------------
    DWORD GetFrameCount() const;

    //----------------------------------------------------------------------------------------
    //! @brief      FPS擾܂.
    //!
    //! @return     FPSԋp܂.
    //----------------------------------------------------------------------------------------
    FLOAT GetFPS() const;

private:
    //========================================================================================
    // private variables.
    //========================================================================================
    bool    m_IsStopRendering;      //!< `~邩ǂ̃tO. ~ꍇtruew.
    DWORD   m_FrameCount;           //!< t[JEgł.
    FLOAT   m_FPS;                  //!< FPS(1b̃t[`)ł.
    DOUBLE  m_LatestUpdateTime;     //!< Ō̍XVԂł.

    //========================================================================================
    // private methods.
    //========================================================================================
    Application     ( const Application& );     // ANZX֎~.
    void operator = ( const Application& );     // ANZX֎~.

    //----------------------------------------------------------------------------------------
    //! @brief      AvP[V̏ł.
    //!
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //! @note       ̃\bh͓ŁCInitWnd(), InitD3D()Ăяo܂.
    //----------------------------------------------------------------------------------------
    bool InitApp();

    //----------------------------------------------------------------------------------------
    //! @brief      AvP[V̏Ił.
    //!
    //! @note       ̃\bh͓, TermD3D(), TermWnd()Ăяo܂.
    //----------------------------------------------------------------------------------------
    void TermApp();

    //----------------------------------------------------------------------------------------
    //! @brief      EBhȄł.
    //!
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //----------------------------------------------------------------------------------------
    bool InitWnd();

    //----------------------------------------------------------------------------------------
    //! @brief      EBhȄIł.
    //----------------------------------------------------------------------------------------
    void TermWnd();

    //----------------------------------------------------------------------------------------
    //! @brief      Direct3D̏ł.
    //!
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //----------------------------------------------------------------------------------------
    bool InitD3D();

    //----------------------------------------------------------------------------------------
    //! @brief      Direct3D̏Ił.
    //----------------------------------------------------------------------------------------
    void TermD3D();

    //----------------------------------------------------------------------------------------
    //! @brief      C[vł.
    //----------------------------------------------------------------------------------------
    void MainLoop();

    //----------------------------------------------------------------------------------------
    //! @brief      L[Cxg܂.
    //!
    //! @param [in]     nChar       L[R[h.
    //! @param [in]     isKeyDown   L[Ă邩ǂ. L[Ătruew肵܂.
    //! @param [in]     isAltDown   ALTL[Ă邩ǂ. ALTL[Ătruew肵܂.
    //! @note       ̃\bh͓ŁCOnKey()Ăяo܂.
    //!             ܂C̃\bh̓EBhEvV[W̃ANZXp\bhł̂,
    //!             AvP[VŌĂяosȂł.
    //----------------------------------------------------------------------------------------
    void KeyEvent   ( UINT nChar, bool isKeyDown, bool isAltDown );

    //----------------------------------------------------------------------------------------
    //! @brief      TCYCxg܂.
    //!
    //! @param [in]     width       ʂ̉.
    //! @param [in]     height      ʂ̏c.
    //! @note       ̃\bh͓, OnResize()Ăяo܂.
    //!             ܂C̃\bh̓EBhEvV[W̃ANZXp\bhł̂,
    //!             AvP[VŌĂяosȂł.
    //----------------------------------------------------------------------------------------
    void ResizeEvent( UINT width, UINT height );

    //----------------------------------------------------------------------------------------
    //! @brief      }EXCxg܂.
    //!
    //! @param [in]     x                   J[\XWł.
    //! @param [in]     y                   J[\YWł.
    //! @param [in]     wheelDelta          }EXzC[̈ړł.
    //! @param [in]     isLeftButtonDown    {^ꂽǂ.Ătruew肵܂.
    //! @param [in]     isRightButtonDown   E{^ꂽǂ.Ătruew肵܂.
    //! @param [in]     isMiddleButtonDown  {^ꂽǂ.Ătruew肵܂.
    //! @param [in]     isSideButton1Down   X1{^ꂽǂ.Ătruew肵܂.
    //! @param [in]     isSideButton2Down   X2{^ꂽǂ.Ătruew肵܂.
    //! @note       ̃\bh͓, OnMouse()Ăяo܂.
    //!             ܂C̃\bh̓EBhEvV[W̃ANZXp\bhł̂,
    //!             AvP[VŌĂяosȂł.
    //----------------------------------------------------------------------------------------
    void MouseEvent(
        int     x,
        int     y,
        int     wheelDelta,
        bool    isLeftButtonDown,
        bool    isRightButtonDown,
        bool    isMiddleButtonDown,
        bool    isSideButton1Down,
        bool    isSideButton2Down );

    //----------------------------------------------------------------------------------------
    //! @brief      EBhEvV[Wł.
    //!
    //! @param [in]     hWnd        EBhEnh.
    //! @param [in]     uMsg        bZ[W.
    //! @param [in]     wp          bZ[W̒ǉ.
    //! @param [in]     lp          bZ[W̒ǉ.
    //----------------------------------------------------------------------------------------
    static LRESULT CALLBACK MsgProc( HWND hWnd, UINT uMsg, WPARAM wp, LPARAM lp );
};


} // namespace asdx

#endif//__ASDX_APP_H__