//------------------------------------------------------------------------------------------
// File : SimplePS.fx
// Desc : Simple Pixel Shader
// Copyright(c) Project Asura. All right reserved.
//------------------------------------------------------------------------------------------

//------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------
#include "SimpleDecl.fxh"


PSOutput PSFunc( VSOutput input )
{
    PSOutput output = (PSOutput)0;

    float3 diffuse  = Lambert( Diffuse, input.LightDir, input.Normal );
    float3 specular = Phong( Specular, Power, input.ViewDir, input.Normal, input.LightDir );

    output.Color0.xyz = diffuse + specular;
    output.Color0.a   = Alpha;

    //output.Color0.xyz = Diffuse;
    //output.Color0.a   = 1.0f;

    return output;

}