//------------------------------------------------------------------------------
// File : SampleApp.h
// Desc : Sample Application.
// Copyright(c) Project Asura. All right reserved.
//------------------------------------------------------------------------------

#ifndef __SAMPLE_APP_H__
#define __SAMPLE_APP_H__

//------------------------------------------------------------------------------
// Include
//------------------------------------------------------------------------------
#include <asdxApp.h>
#include <asdxMesh.h>
#include <asdxCameraUpdater.h>
#include <SpriteFont.h>
#include <CommonStates.h>


/////////////////////////////////////////////////////////////////////////////////////////
// TrasnsformParam structure
/////////////////////////////////////////////////////////////////////////////////////////
struct TransformParam
{
    asdx::MATRIX    World;          //!< [hs.
    asdx::MATRIX    View;           //!< r[s.
    asdx::MATRIX    Proj;           //!< ˉes.
    asdx::FLOAT4    Light;          //!< Cg.
};


/////////////////////////////////////////////////////////////////////////////////////////
// SimpleMaterial structure
/////////////////////////////////////////////////////////////////////////////////////////
struct SimpleMaterial
{
    asdx::FLOAT4    Diffuse;        //!< gUː+ߓx.
    asdx::FLOAT4    Spcular;        //!< ʔː+ʔˋx.
};


////////////////////////////////////////////////////////////////////////////////////////
// SimpleSubset structure
////////////////////////////////////////////////////////////////////////////////////////
struct SimpleSubset
{
    asdx::UINT      IndexOffset;    //!< _CfbNX̃ItZbgł.
    asdx::UINT      IndexCount;     //!< CfbNXł.
    SimpleMaterial  Material;       //!< }eAł.
};


////////////////////////////////////////////////////////////////////////////////////////
// SampleApplication
////////////////////////////////////////////////////////////////////////////////////////
class SampleApplication : public asdx::Application
{
    //==================================================================================
    // list of friend classes and methods.
    //==================================================================================
    /* NOTHING */

private:
    //===================================================================================
    // private variables.
    //===================================================================================
    DirectX::SpriteBatch*       m_pSprites;         //!< XvCgob`ł.
    DirectX::SpriteFont*        m_pFont;            //!< XvCgtHgł.
    asdx::CameraUpdater         m_Camera;           //!< Jł.
    ID3D11Buffer*               m_pVB;              //!< _obt@ł.
    ID3D11Buffer*               m_pIB;              //!< CfbNXobt@ł.
    ID3D11Buffer*               m_pMB;              //!< }eAobt@ł.
    ID3D11Buffer*               m_pTB;              //!< ϊp[^obt@ł.
    ID3D11InputLayout*          m_pIL;              //!< ̓CAEgł.
    ID3D11VertexShader*         m_pVS;              //!< _VF[_ł.
    ID3D11PixelShader*          m_pPS;              //!< sNZVF[_ł.
    asdx::UINT                  m_Stride;           //!< XgChł.
    asdx::UINT                  m_Offset;           //!< ItZbgł.
    asdx::UINT                  m_SubsetCount;      //!< TuZbgł.
    SimpleSubset*               m_pSubset;          //!< TuZbgł.
    TransformParam              m_TransformParam;   //!< ϊp[^ł.
    wchar_t                     m_FpsText[ 20 ];    //!< FPSeLXgł.

    //==================================================================================
    // private methods.
    //==================================================================================

    //----------------------------------------------------------------------------------
    //! @brief      eLXg`掞̏ł.
    //----------------------------------------------------------------------------------
    void OnDrawText();

    //----------------------------------------------------------------------------------
    //! @brief      bV`掞̏ł.
    //----------------------------------------------------------------------------------
    void OnDrawMesh();

protected:
    //==================================================================================
    // protected varaibles
    //==================================================================================
    /* NOTHING */

    //==================================================================================
    // protected methods.
    //==================================================================================

    //----------------------------------------------------------------------------------
    //! @brief      ̏ł.
    //!
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //----------------------------------------------------------------------------------
    bool OnInit();

    //----------------------------------------------------------------------------------
    //! @brief      Ȉł.
    //----------------------------------------------------------------------------------
    void OnTerm();

    //----------------------------------------------------------------------------------
    //! @brief      t[@ێ̏ł.
    //!
    //! @param [in]     time            AvP[VJnĂ̑ΎԂł.
    //! @param [in]     elapsedTime     Ot[̌oߎԂł.
    //----------------------------------------------------------------------------------
    void OnFrameMove  ( double time, double elapsedTime );

    //----------------------------------------------------------------------------------
    //! @brief      t[`掞̏ł.
    //!
    //! @param [in]     time            AvP[VJnĂ̑ΎԂł.
    //! @param [in]     elapsedTime     Ot[̌oߎԂł.
    //----------------------------------------------------------------------------------
    void OnFrameRender( double time, double elapsedTime );

    //----------------------------------------------------------------------------------
    //! @brief      TCY̏ł.
    //!
    //! @param [in]     param           TCYCxgp[^ł.
    //----------------------------------------------------------------------------------
    void OnResize     ( const asdx::ResizeEventParam& param );

    //----------------------------------------------------------------------------------
    //! @brief      L[Cxg̏ł.
    //!
    //! @param [in]     param           L[Cxgp[^ł.
    //----------------------------------------------------------------------------------
    void OnKey        ( const asdx::KeyEventParam& param );

    //----------------------------------------------------------------------------------
    //! @brief      }EXCxg̏ł.
    //!
    //! @param [in]     param           }EXCxgp[^ł.
    //----------------------------------------------------------------------------------
    void OnMouse      ( const asdx::MouseEventParam& param );

public:
    //==================================================================================
    // public variables.
    //==================================================================================
    /* NOTHING */

    //==================================================================================
    // public methods.
    //==================================================================================

    //----------------------------------------------------------------------------------
    //! @brief      RXgN^ł.
    //----------------------------------------------------------------------------------
    SampleApplication();

    //----------------------------------------------------------------------------------
    //! @brief      fXgN^ł.
    //----------------------------------------------------------------------------------
    virtual ~SampleApplication();
};



#endif//__SAMPLE_APP_H__
