//--------------------------------------------------------------------------------------------
// File : asdxCamera.cpp
// Desc : Camera Module.
// Copyright(c) Project Asura. All right reserved.
//--------------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------------
// Includes
//--------------------------------------------------------------------------------------------
#include <asdxCamera.h>


namespace /* anonymos */ {

//--------------------------------------------------------------------------------------------
//      px߂܂.
//--------------------------------------------------------------------------------------------
static inline 
float GetAngle( float sin, float cos )
{
    float angle = asinf( sin );

    if ( cos < 0.0f )
    { angle = asdx::F_PI - angle; }

    return angle;
}

//--------------------------------------------------------------------------------------------
//      w肳ꂽʒuƃ^[Qbgpxɕϊ܂.
//--------------------------------------------------------------------------------------------
static inline 
void ToAngle
( 
    const asdx::FLOAT3& position,
    const asdx::FLOAT3& target,
    asdx::FLOAT2&       angle
)
{
    asdx::FLOAT3 dir = target - position;
    if ( dir.LengthSquared() != 0.0f )
    { dir.Normalize(); }

    angle.x = GetAngle( dir.x, dir.z );
    angle.y = GetAngle( dir.y, dir.x );
}

//--------------------------------------------------------------------------------------------
//      w肳ꂽpxEE^[Qbgʒuɕϊ܂.
//--------------------------------------------------------------------------------------------
static inline
void ToPosition
(
    const asdx::FLOAT2& angle,
    const float         dist,
    const asdx::FLOAT3& target,
    asdx::FLOAT3&       position
)
{
    register float sinH = sinf( angle.x );
    register float cosH = cosf( angle.x );

    register float sinV = sinf( angle.y );
    register float cosV = cosf( angle.y );

    position.x = target.x + dist * ( -cosV * sinH );
    position.y = target.y + dist * ( -sinV );
    position.z = target.z + dist * ( -cosV * cosH );
}

//--------------------------------------------------------------------------------------------
//      w肳ꂽpxAbvxNgɕϊ܂.
//--------------------------------------------------------------------------------------------
static inline
void ToUpward
(
    const asdx::FLOAT2& angle,
    asdx::FLOAT3&       upward
)
{
    register float sinH = sinf( angle.x );
    register float cosH = cosf( angle.x );

    register float sinV = sinf( angle.y );
    register float cosV = cosf( angle.y );

    upward.x = -sinV * sinH;
    upward.y =  cosV;
    upward.z = -sinV * cosH;
}

} // namespace /* anonymos */ 



namespace asdx {

//////////////////////////////////////////////////////////////////////////////////////////////
// Camera class
//////////////////////////////////////////////////////////////////////////////////////////////

//--------------------------------------------------------------------------------------------
//      RXgN^ł.
//--------------------------------------------------------------------------------------------
Camera::Camera()
: m_Param()
, m_Preset()
{ m_View.Identity(); }

//--------------------------------------------------------------------------------------------
//      fXgN^ł.
//--------------------------------------------------------------------------------------------
Camera::~Camera()
{ /* DO_NOTHING */ }

//--------------------------------------------------------------------------------------------
//      ʒuݒ肵܂.
//--------------------------------------------------------------------------------------------
void Camera::SetPosition( const asdx::FLOAT3& position )
{
    m_Param.Position = position;

    ClampDist();
    ComputeAngle();
}

//--------------------------------------------------------------------------------------------
//      _ݒ肵܂.
//--------------------------------------------------------------------------------------------
void Camera::SetTarget( const asdx::FLOAT3& target )
{
    m_Param.Target = target;

    ClampDist();
    ComputeAngle();
}

//--------------------------------------------------------------------------------------------
//      xNgݒ肵܂.
//--------------------------------------------------------------------------------------------
void Camera::SetUpward( const asdx::FLOAT3& upward )
{ m_Param.Upward = upward; }

//--------------------------------------------------------------------------------------------
//      cCXgpݒ肵܂.
//--------------------------------------------------------------------------------------------
void Camera::SetTwist( const float twist )
{ m_Param.Twist = twist; }

//--------------------------------------------------------------------------------------------
//      ͈͂ݒ肵܂.
//--------------------------------------------------------------------------------------------
void Camera::SetRange( const float minDist, const float maxDist )
{
    m_Param.MinDist = minDist;
    m_Param.MaxDist = maxDist;

    ClampDist();
    ComputeAngle();
}

//--------------------------------------------------------------------------------------------
//      p[^ۑ܂.
//--------------------------------------------------------------------------------------------
void Camera::Preset()
{ m_Preset = m_Param; }

//--------------------------------------------------------------------------------------------
//      p[^Zbg܂.
//--------------------------------------------------------------------------------------------
void Camera::Reset()
{
    m_Param = m_Preset;

    ClampDist();
    ComputeAngle();
}

//--------------------------------------------------------------------------------------------
//      r[s擾܂.
//--------------------------------------------------------------------------------------------
asdx::MATRIX Camera::GetView() const
{ return m_View; }

//--------------------------------------------------------------------------------------------
//      ʒu擾܂.
//--------------------------------------------------------------------------------------------
asdx::FLOAT3 Camera::GetPosition() const
{ return m_Param.Position; }

//--------------------------------------------------------------------------------------------
//      _擾܂.
//--------------------------------------------------------------------------------------------
asdx::FLOAT3 Camera::GetTarget() const
{ return m_Param.Target; }

//--------------------------------------------------------------------------------------------
//      xNg擾܂.
//--------------------------------------------------------------------------------------------
asdx::FLOAT3 Camera::GetUpward() const
{ return m_Param.Upward; }

//--------------------------------------------------------------------------------------------
//      cCXgp擾܂.
//--------------------------------------------------------------------------------------------
float Camera::GetTwist() const
{ return m_Param.Twist; }

//--------------------------------------------------------------------------------------------
//      ŏ擾܂.
//--------------------------------------------------------------------------------------------
float Camera::GetMinDist() const
{ return m_Param.MinDist; }

//--------------------------------------------------------------------------------------------
//      ő勗擾܂.
//--------------------------------------------------------------------------------------------
float Camera::GetMaxDist() const
{ return m_Param.MaxDist; }

//--------------------------------------------------------------------------------------------
//      pxvZ܂.
//--------------------------------------------------------------------------------------------
void Camera::ComputeAngle()
{
    // ]pvZ.
    ToAngle( m_Param.Position, m_Param.Target, m_Param.Rotate );

    // pE`gpvZ.
    ToAngle( m_Param.Target, m_Param.Position, m_Param.PanTilt );
}

//--------------------------------------------------------------------------------------------
//      ͈͓ɐ܂.
//--------------------------------------------------------------------------------------------
void Camera::ClampDist()
{
    // Zo.
    float dist = asdx::Distance( m_Param.Position, m_Param.Target );

    // xNg
    asdx::FLOAT3 dir = m_Param.Position - m_Param.Target;

    // ő勗𒴂Ȃ悤ɐ.
    if ( dist > m_Param.MaxDist )
    {
        // [Z΍.
        if ( dir.LengthSquared() != 0.0 )
        { dir.Normalize(); }

        m_Param.Position = m_Param.Target + dir * m_Param.MaxDist;
    }

    // ŏȂ悤ɐ.
    if ( dist < m_Param.MinDist )
    {
        // [Z΍.
        if ( dir.LengthSquared() != 0.0f )
        { dir.Normalize(); }

        m_Param.Position = m_Param.Target + dir * m_Param.MinDist;
    }
}

//--------------------------------------------------------------------------------------------
//      r[sXV܂.
//--------------------------------------------------------------------------------------------
void Camera::Update()
{
    asdx::FLOAT3 upward = m_Param.Upward;

    // cCXgp[łȂꍇ.
    if ( m_Param.Twist != 0.0f )
    {
        // xNg쐬.
        asdx::FLOAT3 dir = m_Param.Target - m_Param.Position;
        if ( dir.LengthSquared() != 0.0f )
        { dir.Normalize(); }

        // xNgƂ]s쐬.
        asdx::MATRIX rotate = asdx::CreateFromAxisAngle( dir, m_Param.Twist );

        // AbvxNg].
        upward = asdx::Transform( upward, rotate );
    }

    // r[sXV.
    m_View = asdx::CreateLookAt( m_Param.Position, m_Param.Target, upward );
}

//--------------------------------------------------------------------------------------------
//      JCxgɃr[sXV܂.
//--------------------------------------------------------------------------------------------
void Camera::UpdateByEvent( const CameraEvent& camEvent )
{
    // ].
    if ( camEvent.Flags & CameraEvent::EVENT_ROTATE )
    {
        // ]pZ.
        m_Param.Rotate += camEvent.Rotate;

        // ^[Qbg܂ł̋Zo.
        float dist = asdx::Distance( m_Param.Position, m_Param.Target );

        // ʒuxNgXV.
        ToPosition( m_Param.Rotate, dist, m_Param.Target, m_Param.Position );

        // AbvxNgXV.
        ToUpward( m_Param.Rotate, m_Param.Upward );
    }

    // h[.
    if ( camEvent.Flags & CameraEvent::EVENT_DOLLY )
    {
        // xNg쐬.
        asdx::FLOAT3 dir = m_Param.Position - m_Param.Target;
        float dist = asdx::Distance( m_Param.Position, m_Param.Target );

        // K.
        if ( dist != 0.0f )
        {
            float invDist = 1.0f / dist;
            dir.x *= invDist;
            dir.y *= invDist;
            dir.z *= invDist;
        }

        // h[ʂZ.
        dist += camEvent.Dolly;

        // ͈͓ɐ.
        if ( m_Param.MinDist > dist )
        { dist = m_Param.MinDist; }
        if ( m_Param.MaxDist < dist )
        { dist = m_Param.MaxDist; }

        // ʒuxNgXV.
        m_Param.Position = m_Param.Target + ( dir * dist );
    }

    // gbN.
    if ( camEvent.Flags & CameraEvent::EVENT_TRUCK )
    {
        m_Param.Position += camEvent.Truck;
        m_Param.Target   += camEvent.Truck;
    }

    // pE`g.
    if ( camEvent.Flags & CameraEvent::EVENT_PANTILT )
    {
        // pE`gpZ.
        m_Param.PanTilt += camEvent.PanTilt;

        // ^[QbgƂ̋Zo.
        float dist = asdx::Distance( m_Param.Target, m_Param.Position );

        // ^[QbgʒuXV.
        ToPosition( m_Param.PanTilt, dist, m_Param.Position, m_Param.Target );

        // AbvxNgXV.
        ToUpward( -m_Param.PanTilt, m_Param.Upward );
    }

    // cCXg.
    if ( camEvent.Flags & CameraEvent::EVENT_TWIST )
    { m_Param.Twist += camEvent.Twist; }

    // Zbg.
    if ( camEvent.Flags & CameraEvent::EVENT_RESET )
    { Reset(); }

    // r[sXV.
    Update();
}


} // namespace asdx

