//-------------------------------------------------------------------------------------------
// File : asdxCameraUpdater.h
// Desc : Camera Updater Module.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------

#ifndef __ASDX_CAMERA_UPDATER_H__
#define __ASDX_CAMERA_UPDATER_H__

//-------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------
#include <asdxCamera.h>


namespace asdx {

/////////////////////////////////////////////////////////////////////////////////////////////
// CameraUpdate class
/////////////////////////////////////////////////////////////////////////////////////////////
class CameraUpdater
{
    //=======================================================================================
    // list of friend classed and methods.
    //=======================================================================================
    /* NOTHING */

private:
    //=======================================================================================
    // private variables.
    //=======================================================================================
    /* NOTHING */

    //=======================================================================================
    // private methods.
    //=======================================================================================
    /* NOTHING */

protected:
    //=======================================================================================
    // protected variables
    //=======================================================================================
    struct MouseState
    {
        int  X;             //!< ݂̃J[\XWł.
        int  Y;             //!< ݂̃J[\YWł.
        int  prevX;         //!< ȑÕJ[\XWł.
        int  prevY;         //!< ȑÕJ[\YWł.
        bool isClick;       //!< ݃{^ꂽǂ.
        bool isPrevClick;   //!< ȑO{^ꂽǂ

        //-----------------------------------------------------------------------------------
        //! @brief      RXgN^ł.
        //-----------------------------------------------------------------------------------
        MouseState()
        : X          ( 0 )
        , Y          ( 0 )
        , prevX      ( 0 )
        , prevY      ( 0 )
        , isClick    ( false )
        , isPrevClick( false )
        { /* DO_NOTHING */ }

        //-----------------------------------------------------------------------------------
        //! @brief      fXgN^ł.
        //-----------------------------------------------------------------------------------
        virtual ~MouseState()
        { /* DO_NOTHING */ }

        //-----------------------------------------------------------------------------------
        //! @brief      p[^Zbg܂.
        //-----------------------------------------------------------------------------------
        void Reset()
        {
            X           = 0;
            Y           = 0;
            prevX       = 0;
            prevY       = 0;
            isClick     = false;
            isPrevClick = false;
        }

        //-----------------------------------------------------------------------------------
        //! @brief      p[^XV܂.
        //!
        //! @param [in]     x       J[\XW.
        //! @param [in]     y       J[\YW.
        //! @param [in]     isDown  {^Ătrue.
        //-----------------------------------------------------------------------------------
        void Update( int x, int y, bool isDown )
        {
            // ȑȌԂXV.
            prevX       = X;
            prevY       = Y;
            isPrevClick = isClick;

            // ݂̏ԂXV.
            X           = x;
            Y           = y;
            isClick     = isDown;
        }
    };

    Camera      m_Camera;               //!< Jł.
    MouseState  m_MouseLeft;            //!< }EX̍{^̏Ԃł.
    MouseState  m_MouseRight;           //!< }EX̉E{^̏Ԃł.
    MouseState  m_MouseMiddle;          //!< }EX̉E{^̏Ԃł.

    //=======================================================================================
    // protected methods.
    //=======================================================================================

    //---------------------------------------------------------------------------------------
    //! @brief      }EX̏ԂJCxg𐶐܂.
    //---------------------------------------------------------------------------------------
    CameraEvent MakeEventFromMouse( int wheelDelta );

    //---------------------------------------------------------------------------------------
    //! @brief      L[̏ԂJCxg쐬܂.
    //---------------------------------------------------------------------------------------
    CameraEvent MakeEventFromKey( unsigned int nChar, bool isKeyDown, bool isAltDown );

public:
    //=======================================================================================
    // public variables.
    //=======================================================================================
    /* NOTHING */

    //=======================================================================================
    // public methods.
    //=======================================================================================

    //---------------------------------------------------------------------------------------
    //! @brief      RXgN^ł.
    //---------------------------------------------------------------------------------------
    CameraUpdater();

    //---------------------------------------------------------------------------------------
    //! @brief      fXgN^ł.
    //---------------------------------------------------------------------------------------
    virtual ~CameraUpdater();

    //---------------------------------------------------------------------------------------
    //! @brief      ݒs܂.
    //---------------------------------------------------------------------------------------
    void Init(
        asdx::FLOAT3 cameraPos,
        asdx::FLOAT3 cameraAim,
        asdx::FLOAT3 cameraUp,
        float        nearClip,
        float        farClip
    );

    //---------------------------------------------------------------------------------------
    //! @brief      }EX̏ł.
    //---------------------------------------------------------------------------------------
    void OnMouse ( int x, int y, int wheelDelta, bool isLeftButtonDown, bool isRightButtonDown, bool isMiddleButtonDown, bool isSideButton1Down, bool isSideButton2Down );

    //---------------------------------------------------------------------------------------
    //! @brief      L[̏ł.
    //---------------------------------------------------------------------------------------
    void OnKey   ( unsigned int nChar, bool isKeyDown, bool isAltDown );

    //---------------------------------------------------------------------------------------
    //! @brief      J擾܂.
    //---------------------------------------------------------------------------------------
    Camera& GetCamera();

    //---------------------------------------------------------------------------------------
    //! @brief      r[s擾܂.
    //---------------------------------------------------------------------------------------
    asdx::MATRIX GetView() const;
};


} // namespace asdx

#endif//__ASDX_CAMERA_UPDATER_H__
