//--------------------------------------------------------------------------------------------
// File : ShaderUtil.cpp
// Desc : Shader Utility Module.
// Copyright(c) Project Asura. All right reserved.
//---------------------------------------------------------------------------------------------

//---------------------------------------------------------------------------------------------
// Includes
//---------------------------------------------------------------------------------------------
#include "ShaderUtil.h"


//---------------------------------------------------------------------------------------------
//      t@CVF[_RpC܂.
//---------------------------------------------------------------------------------------------
HRESULT CompileShaderFromFile
(
    WCHAR*      szFileName,
    LPCSTR      szEntryPoint,
    LPCSTR      szShaderModel,
    ID3DBlob**  ppBlobOut
)
{
    // ^[R[h.
    HRESULT hr = S_OK;

    // RpCtO.
    DWORD dwShaderFlags = D3DCOMPILE_ENABLE_STRICTNESS;

#if defined(DEBUG) || defined(_DEBUG)
    dwShaderFlags |= D3DCOMPILE_DEBUG;
#endif//defiend(DEBUG) || defined(_DEBUG)

#if defined(NDEBUG) || defined(_NDEBUG)
    dwShaderFlags |= D3DCOMPILE_OPTIMIZATION_LEVEL3;
#endif//defined(NDEBUG) || defined(_NDEBUG)

    ID3DBlob* pErrorBlob = NULL;

    // t@CVF[_RpC.
    hr = D3DCompileFromFile(
        szFileName,
        NULL,
        D3D_COMPILE_STANDARD_FILE_INCLUDE,
        szEntryPoint,
        szShaderModel,
        dwShaderFlags,
        0,
        ppBlobOut,
        &pErrorBlob 
    );

    // G[`FbN.
    if ( FAILED( hr ) )
    {
        // G[bZ[Wo.
        if ( pErrorBlob != NULL )
        { OutputDebugStringA( (char*)pErrorBlob->GetBufferPointer() ); }
    }

    // .
    if ( pErrorBlob )
    {
        pErrorBlob->Release();
        pErrorBlob = NULL;
    }

    // ^[R[hԋp.
    return hr;
}