//------------------------------------------------------------------------------------
// File : DemoNode.cpp
// Desc : Demo Node Module.
// Copyright(c) Project Asura. All right reserved.
//------------------------------------------------------------------------------------

//------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------
#include <cassert>
#include "DemoNode.h"
#include "ShaderUtil.h"


/////////////////////////////////////////////////////////////////////////////////////////
// CustomVertex structure
/////////////////////////////////////////////////////////////////////////////////////////
struct CustomVertex
{
    DirectX::XMFLOAT3 position;     //!< ʒuWł.
};


///////////////////////////////////////////////////////////////////////////////////////
// ConstnatBufferForPerFrame
///////////////////////////////////////////////////////////////////////////////////////
struct ConstantBufferForPerFrame
{
    DirectX::XMMATRIX world;        //!< [hsł.
    DirectX::XMMATRIX view;         //!< r[sł.
    DirectX::XMMATRIX proj;         //!< ˉesł.
};


//////////////////////////////////////////////////////////////////////////////////////
// DemoNode class
//////////////////////////////////////////////////////////////////////////////////////

//------------------------------------------------------------------------------------
//      RXgN^ł.
//------------------------------------------------------------------------------------
DemoNode::DemoNode()
: m_pVS( NULL )
, m_pGS( NULL )
, m_pPS( NULL )
, m_pIL( NULL )
, m_pVB( NULL )
, m_pCB( NULL )
{
    m_World = DirectX::XMMatrixIdentity();
    m_View  = DirectX::XMMatrixIdentity();
    m_Proj  = DirectX::XMMatrixIdentity();
}

//------------------------------------------------------------------------------------
//      fXgN^ł.
//------------------------------------------------------------------------------------
DemoNode::~DemoNode()
{
    OnTerm();
}

//------------------------------------------------------------------------------------
//      ̏ł.
//------------------------------------------------------------------------------------
bool DemoNode::OnInit
(
    ID3D11Device*        pDevice,
    ID3D11DeviceContext* pDeviceContext,
    const UINT           width,
    const UINT           height 
)
{
    HRESULT hr = S_OK;

    // _VF[_RpC.
    ID3DBlob* pVSBlob = NULL;
    // t@CpX$(ProjectDir)݂΃pXɂȂĂ܂.
    hr = CompileShaderFromFile( L"../res/Simple.fx", "VSFunc", "vs_4_0", &pVSBlob );
    if ( FAILED( hr ) )
    {
        assert( false && "CompileShaderFromFile() Failed" );
        return false;
    }

    // _VF[_.
    hr = pDevice->CreateVertexShader( pVSBlob->GetBufferPointer(), pVSBlob->GetBufferSize(), NULL, &m_pVS );
    if ( FAILED( hr ) )
    {
        assert( false && "ID3D11Device::CreateVertexShader() Failed." );
        pVSBlob->Release();
        pVSBlob = NULL;
        return false;
    }

    // ̓CAEg̒`.
    D3D11_INPUT_ELEMENT_DESC layout[] = {
        { "POSITION", 0, DXGI_FORMAT_R32G32B32_FLOAT, 0, 0, D3D11_INPUT_PER_VERTEX_DATA, 0 },
    };
    UINT numElements = ARRAYSIZE( layout );

    // ̓CAEg𐶐.
    hr = pDevice->CreateInputLayout( 
        layout,
        numElements,
        pVSBlob->GetBufferPointer(),
        pVSBlob->GetBufferSize(),
        &m_pIL
    );
    pVSBlob->Release();
    pVSBlob = NULL;
    if ( FAILED( hr ) )
    {
        assert( false && "ID3D11Device::CreateInputLayout() Failed." );
        return false;
    }

    // ̓AZuɓ̓CAEgݒ.
    pDeviceContext->IASetInputLayout( m_pIL );

    // WIgVF[_RpC.
    {
        ID3DBlob* pGSBlob = NULL;
        // t@CpX$(ProjectDir)݂΃pXɂȂĂ܂.
        hr = CompileShaderFromFile( L"../res/Simple.fx", "GSFunc", "gs_4_0", &pGSBlob );
        if ( FAILED( hr ) )
        {
            assert( false && "CompileShaderFromFile() Failed" );
            return false;
        }

        // WIgVF[_𐶐.
        hr = pDevice->CreateGeometryShader( 
            pGSBlob->GetBufferPointer(),
            pGSBlob->GetBufferSize(),
            NULL,
            &m_pGS
        );
        pGSBlob->Release();
        pGSBlob = NULL;

        if ( FAILED( hr ) )
        {
            assert( false && "ID3D11Device::CreateGeometryShader() Failed." );
            return false;
        }
    }

    // sNZVF[_RpC.
    {
        ID3DBlob* pPSBlob = NULL;
        // t@CpX$(ProjectDir)݂΃pXɂȂĂ܂.
        hr = CompileShaderFromFile( L"../res/Simple.fx", "PSFunc", "ps_4_0", &pPSBlob );
        if ( FAILED( hr ) )
        {
            assert( false && "CompileShaderFromFile() Failed" );
            return false;
        }

        // sNZVF[_𐶐.
        hr = pDevice->CreatePixelShader(
            pPSBlob->GetBufferPointer(),
            pPSBlob->GetBufferSize(),
            NULL,
            &m_pPS 
        );
        pPSBlob->Release();
        pPSBlob = NULL;
        if ( FAILED( hr ) )
        {
            assert( false && "ID3D11Device::CreatePixelShader() Failed." );
            return false;
        }
    }

    // _obt@̐ݒ.
    {
        // _̒`.
        CustomVertex vertices[] = {
            DirectX::XMFLOAT3(  0.0f,  0.5f, 0.0f ),
            DirectX::XMFLOAT3(  0.5f, -0.5f, 0.0f ),
            DirectX::XMFLOAT3( -0.5f, -0.5f, 0.0f ),
        };

        D3D11_BUFFER_DESC bd;
        ZeroMemory( &bd, sizeof( D3D11_BUFFER_DESC ) );
        bd.Usage          = D3D11_USAGE_DEFAULT;
        bd.ByteWidth      = sizeof( CustomVertex ) * 3;
        bd.BindFlags      = D3D11_BIND_VERTEX_BUFFER;
        bd.CPUAccessFlags = 0;

        // Tu\[X̐ݒ.
        D3D11_SUBRESOURCE_DATA initData;
        ZeroMemory( &initData, sizeof( D3D11_SUBRESOURCE_DATA ) );
        initData.pSysMem = vertices;

        // _obt@̐.
        hr = pDevice->CreateBuffer( &bd, &initData, &m_pVB );
        if ( FAILED( hr ) )
        {
            assert( false && "ID3D11Device::CreateBuffer() Failed." );
            return false;
        }

        // ̓AZuɒ_obt@ݒ.
        UINT stride = sizeof( CustomVertex );
        UINT offset = 0;
        pDeviceContext->IASetVertexBuffers( 0, 1, &m_pVB, &stride, &offset );

        // v~eBu̎ނݒ.
        pDeviceContext->IASetPrimitiveTopology( D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST );
    }

    // 萔obt@̐.
    {
        // 萔obt@̐ݒ.
        D3D11_BUFFER_DESC bd;
        ZeroMemory( &bd, sizeof( D3D11_BUFFER_DESC ) );
        bd.ByteWidth        = sizeof( ConstantBufferForPerFrame );
        bd.Usage            = D3D11_USAGE_DEFAULT;
        bd.BindFlags        = D3D11_BIND_CONSTANT_BUFFER;
        bd.CPUAccessFlags   = 0;

        // 萔obt@𐶐.
        hr = pDevice->CreateBuffer( &bd, NULL, &m_pCB );
        if ( FAILED( hr ) )
        {
            assert( false && "ID3D11Device::CreateBuffer() Failed." );
            return false;
        }
    }

    // s̐ݒ.
    {
        // Jݒ.
        DirectX::XMVECTOR camPos    = DirectX::XMVectorSet( 0.0f, 0.0f, -0.75f, 0.0f );
        DirectX::XMVECTOR camTarget = DirectX::XMVectorSet( 0.0f, 0.0f,  0.0f, 0.0f );
        DirectX::XMVECTOR camUpward = DirectX::XMVectorSet( 0.0f, 1.0f,  0.0f, 0.0f );

        // r[sݒ.
        m_View = DirectX::XMMatrixLookAtLH( camPos, camTarget, camUpward );

        // AXyNgZo.
        FLOAT aspectRatio = (FLOAT)width/(FLOAT)height;

        // ˉesZo.
        m_Proj = DirectX::XMMatrixPerspectiveFovLH( DirectX::XM_PIDIV2, aspectRatio, 0.01f, 1000.0f );
    }

    // I.
    return true;
}

//------------------------------------------------------------------------------------
//      TCY̏ł.
//------------------------------------------------------------------------------------
void DemoNode::OnResize
(
    ID3D11Device*           pDevice,
    ID3D11DeviceContext*    pDeviceContext,
    const UINT              width,
    const UINT              height 
)
{
    // ˉes̐ݒ.
    {
        // AXyNgZo.
        FLOAT aspectRatio = (FLOAT)width/(FLOAT)height;

        // ˉesZo.
        m_Proj = DirectX::XMMatrixPerspectiveFovLH( DirectX::XM_PIDIV2, aspectRatio, 0.01f, 1000.0f );
    }
}

//------------------------------------------------------------------------------------
//      Ȉł.
//------------------------------------------------------------------------------------
void DemoNode::OnTerm()
{
    // _VF[_.
    if ( m_pVS )
    {
        m_pVS->Release();
        m_pVS = NULL;
    }

    // WIgVF[_.
    if ( m_pGS )
    {
        m_pGS->Release();
        m_pGS = NULL;
    }

    // sNZVF[_.
    if ( m_pPS )
    {
        m_pPS->Release();
        m_pPS = NULL;
    }

    // _obt@.
    if ( m_pVB )
    {
        m_pVB->Release();
        m_pVB = NULL;
    }

    // ̓CAEg.
    if ( m_pIL )
    {
        m_pIL->Release();
        m_pIL = NULL;
    }

    // 萔obt@.
    if ( m_pCB )
    {
        m_pCB->Release();
        m_pCB = NULL;
    }
}

//------------------------------------------------------------------------------------
//      `掞̏ł.
//------------------------------------------------------------------------------------
void DemoNode::OnRender( ID3D11Device* pDevice, ID3D11DeviceContext* pDeviceContext )
{
    //@VF[_ݒ肵ĕ`.
    pDeviceContext->VSSetShader( m_pVS, NULL, 0 );
    pDeviceContext->GSSetShader( m_pGS, NULL, 0 );
    pDeviceContext->PSSetShader( m_pPS, NULL, 0 );

    // 萔obt@̐ݒ.
    ConstantBufferForPerFrame cb;
    cb.world = m_World;
    cb.view  = m_View;
    cb.proj  = m_Proj;

    // Tu\[XXV.
    pDeviceContext->UpdateSubresource( m_pCB, 0, NULL, &cb, 0, 0 );

    // WIgVF[_ɒ萔obt@ݒ.
    pDeviceContext->GSSetConstantBuffers( 0, 1, &m_pCB );

    // `.
    pDeviceContext->Draw( 3, 0 );
}


