//------------------------------------------------------------------------------------
// File : DemoApp.cpp
// Desc : Demo Application Module.
// Copyright(c) Project Asura. All right reserved.
//------------------------------------------------------------------------------------

//------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------
#include "DemoApp.h"
#include <cstdio>
#include <cassert>


#ifndef DLOG
    #if defined(DEBUG) || defined(_DEBUG)
        #define DLOG( x, ... )      printf_s( "[File:%s, Line:%d] "x"\n", __FILE__, __LINE__, ##__VA_ARGS__ )
    #else   
        #define DLOG( x, ... )
    #endif//defined(DEBUG) || defined(_DEBUG)
#endif//DLOG

#ifndef ELOG
    #define ELOG( x, ... );  \
        fprintf( stderr, "[File:%s, Line:%d] "x"\n", __FILE__, __LINE__, ##__VA_ARGS__ ); \
        assert( false );
#endif//ELOG

/////////////////////////////////////////////////////////////////////////////////////
// DemoApp class
/////////////////////////////////////////////////////////////////////////////////////
DemoApp* DemoApp::s_pThis = NULL;

//-----------------------------------------------------------------------------------
//      tRXgN^ł.
//-----------------------------------------------------------------------------------
DemoApp::DemoApp( const Config& config )
: m_hInst               ( NULL )
, m_hWnd                ( NULL )
, m_DriverType          ( D3D_DRIVER_TYPE_NULL )
, m_FeatureLevel        ( D3D_FEATURE_LEVEL_11_0 )
, m_MultiSampleCount    ( config.multiSampleCount )
, m_MultiSampleQuality  ( config.multiSampleQuality )
, m_SwapChainCount      ( config.swapChainCount )
, m_SwapChainFormat     ( config.swapChainFormat )
, m_DepthStencilFormat  ( config.depthStencilFormat )
, m_pDevice             ( NULL )
, m_pDeviceContext      ( NULL )
, m_pSwapChain          ( NULL )
, m_pRTV                ( NULL )
, m_pDSV                ( NULL )
, m_pRTT                ( NULL )
, m_pDST                ( NULL )
, m_pRTSRV              ( NULL )
, m_pDSSRV              ( NULL )
, m_pNode               ( NULL )
, m_Width               ( config.width )
, m_Height              ( config.height )
, m_Title               ( config.title )
{
    // NAJ[̐ݒ.
    m_ClearColor[ 0 ] = config.clearColorR;
    m_ClearColor[ 1 ] = config.clearColorG;
    m_ClearColor[ 2 ] = config.clearColorB;
    m_ClearColor[ 3 ] = config.clearColorA;

    // AXyNgZo.
    m_AspectRatio = (FLOAT)m_Width /(FLOAT)m_Height;
}

//-----------------------------------------------------------------------------------
//      fXgN^ł.
//-----------------------------------------------------------------------------------
DemoApp::~DemoApp()
{ TermApp(); }

//-----------------------------------------------------------------------------------
//      EBhȄs܂.
//-----------------------------------------------------------------------------------
bool DemoApp::InitWnd()
{
    // CX^Xnh擾܂.
    HINSTANCE hInst = GetModuleHandle( NULL );

    // gݒ.
    s_pThis = this;

    // gEBhENX̐ݒ.
    WNDCLASSEXA wc;
    wc.cbSize           = sizeof( WNDCLASSEXA );
    wc.style            = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc      = WndProc;
    wc.cbClsExtra       = 0;
    wc.cbWndExtra       = 0;
    wc.hInstance        = hInst;
    wc.hIcon            = LoadIcon( hInst, IDI_APPLICATION );
    wc.hCursor          = LoadCursor( NULL, IDC_ARROW );
    wc.hbrBackground    = (HBRUSH)( COLOR_WINDOW + 1 );
    wc.lpszMenuName     = NULL;
    wc.lpszClassName    = m_Title.c_str();
    wc.hIconSm          = LoadIcon( hInst, IDI_APPLICATION );

    // EBhENXo^܂.
    if ( !RegisterClassExA( &wc ) )
    {
        // G[Oo.
        ELOG( "Error : RegisterClassEx() Failed.\n" );

        // ُI.
        return false; 
    }

    // CX^Xnhݒ.
    m_hInst = hInst;

    // `̐ݒ.
    RECT rc = { 0, 0, m_Width, m_Height };

    // w肳ꂽNCAg̈mۂ邽߂ɕKvȃEBhEWvZ܂.
    AdjustWindowRect( &rc, WS_OVERLAPPEDWINDOW, FALSE );

    // EBhE𐶐܂.
    m_hWnd = CreateWindowA(
        m_Title.c_str(),
        m_Title.c_str(),
        WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        ( rc.right - rc.left ),
        ( rc.bottom - rc.top ),
        NULL,
        NULL,
        hInst,
        NULL 
    );

    // `FbN.
    if ( m_hWnd == NULL )
    {
        //@G[Oo.
        ELOG( "Error : CreateWindow() Failed." );

        // ُI.
        return false;
    }

    // EBhE\܂.
    ShowWindow( m_hWnd, SW_SHOWNORMAL );

    // I.
    return true;
}

//-----------------------------------------------------------------------------------
//      EBhȄIs܂.
//-----------------------------------------------------------------------------------
void DemoApp::TermWnd()
{
    if ( m_hInst != NULL )
    { UnregisterClassA( m_Title.c_str(), m_hInst ); }

    m_Title.clear();
    s_pThis = NULL;
}

//-----------------------------------------------------------------------------------
//      D3D11̏s܂.
//-----------------------------------------------------------------------------------
bool DemoApp::InitD3D11()
{
    HRESULT hr = S_OK;

    // EBhETCY擾܂.
    RECT rc;
    GetClientRect( m_hWnd, &rc );
    UINT w = rc.right - rc.left;
    UINT h = rc.bottom - rc.top;

    // 擾TCYݒ肵܂.
    m_Width       = w;
    m_Height      = h;

    // AXyNgZo܂.
    m_AspectRatio = (FLOAT)w / (FLOAT)h;

    // foCXtO.
    UINT createDeviceFlags = 0;
#if defined(DEBUG) || defined(_DEBUG)
    createDeviceFlags |= D3D11_CREATE_DEVICE_DEBUG;
#endif//defined(DEBUG) || deifned(_DEBUG)

    // hCo[^Cv.
    D3D_DRIVER_TYPE driverTypes[] = {
        D3D_DRIVER_TYPE_HARDWARE,
        D3D_DRIVER_TYPE_WARP,
        D3D_DRIVER_TYPE_REFERENCE,
    };
    UINT numDriverTytpes = sizeof( driverTypes ) / sizeof( driverTypes[0] );

    // @\x.
    D3D_FEATURE_LEVEL featureLevels[] = {
        D3D_FEATURE_LEVEL_11_0,
        D3D_FEATURE_LEVEL_10_1,
        D3D_FEATURE_LEVEL_10_0,
    };
    UINT numFeatureLevels = sizeof( featureLevels ) / sizeof( featureLevels[0] );

    // Xbv`FC̍\ݒ.
    DXGI_SWAP_CHAIN_DESC sd;
    ZeroMemory( &sd, sizeof(DXGI_SWAP_CHAIN_DESC) );
    sd.BufferCount                          = m_SwapChainCount;
    sd.BufferDesc.Width                     = w;
    sd.BufferDesc.Height                    = h;
    sd.BufferDesc.Format                    = m_SwapChainFormat;
    sd.BufferDesc.RefreshRate.Numerator     = 60;
    sd.BufferDesc.RefreshRate.Denominator   = 1;
    sd.BufferUsage                          = DXGI_USAGE_RENDER_TARGET_OUTPUT | DXGI_USAGE_SHADER_INPUT;
    sd.OutputWindow                         = m_hWnd;
    sd.SampleDesc.Count                     = m_MultiSampleCount;
    sd.SampleDesc.Quality                   = m_MultiSampleQuality;
    sd.Windowed                             = TRUE;

    for( UINT idx = 0; idx < numDriverTytpes; ++idx )
    {
        // hCo[^Cvݒ.
        m_DriverType = driverTypes[ idx ];

        // foCXƃXbv`FC̐.
        hr = D3D11CreateDeviceAndSwapChain(
            NULL, 
            m_DriverType,
            NULL,
            createDeviceFlags,
            featureLevels,
            numFeatureLevels,
            D3D11_SDK_VERSION,
            &sd,
            &m_pSwapChain,
            &m_pDevice,
            &m_FeatureLevel,
            &m_pDeviceContext 
        );

        // 烋[vEo.
        if ( SUCCEEDED( hr ) )
        { break; }
    }

    // sĂȂ`FbN.
    if ( FAILED( hr ) )
    {
        ELOG( "Error : D3D11CreateDeviceAndSwapChain() Failed." );
        return false;
    }

    // }`Tv̍őil擾.
    hr = m_pDevice->CheckMultisampleQualityLevels( m_SwapChainFormat, m_MultiSampleCount, &m_MultiSampleMaxQuality );
    if ( FAILED( hr ) )
    {
        ELOG( "Error : D3D11Device::CheckMultiSampleQualityLevels() Failed." );
        return false;
    }

    // _[^[Qbg𐶐.
    if ( !CreateDefaultRenderTarget() )
    {
        ELOG( "Error : CreateDefaultRenderTarget() Failed." );
        return false;
    }

    // [xXeVobt@𐶐.
    if ( !CreateDefaultDepthStencil() )
    {
        ELOG( "Error : CreateDefaultDepthStencil() Failed." );
        return false;
    }

    // foCXReLXgɃ_[^[Qbgݒ.
    m_pDeviceContext->OMSetRenderTargets( 1, &m_pRTV, m_pDSV );

    // r[|[g̐ݒ.
    D3D11_VIEWPORT vp;
    vp.Width    = (FLOAT)w;
    vp.Height   = (FLOAT)h;
    vp.MinDepth = 0.0f;
    vp.MaxDepth = 1.0f;
    vp.TopLeftX = 0;
    vp.TopLeftY = 0;

    // foCXReLXgɃr[|[gݒ.
    m_pDeviceContext->RSSetViewports( 1, &vp );

    // AvŗL̏.
    return OnInit();
}

//-----------------------------------------------------------------------------------
//          D3D11̏Is܂.
//-----------------------------------------------------------------------------------
void DemoApp::TermD3D11()
{
    // Xe[gNACftHgԂɂ܂.
    if ( m_pDeviceContext )
    { 
        m_pDeviceContext->ClearState();
        m_pDeviceContext->Flush();
    }

    // AvŗL̏I.
    OnTerm();

    // _[^[Qbg.
    ReleaseDefaultRenderTarget();

    // [xXeVobt@.
    ReleaseDefaultDepthStencil();

    // Xbv`FC܂.
    if ( m_pSwapChain )
    {
        m_pSwapChain->Release();
        m_pSwapChain = NULL;
    }

    // foCXReLXg܂.
    if ( m_pDeviceContext )
    {
        m_pDeviceContext->Release();
        m_pDeviceContext = NULL;
    }

    // foCX܂.
    if ( m_pDevice )
    {
        m_pDevice->Release();
        m_pDevice = NULL;
    }
}

//-----------------------------------------------------------------------------------
//      AvP[V̏s܂.
//-----------------------------------------------------------------------------------
bool DemoApp::InitApp()
{
    // EBhȄ.
    if ( !InitWnd() )
    {
        ELOG( "Error : InitWnd() Failed." );
        return false;
    }

    // D3D11̏.
    if ( !InitD3D11() )
    {
        ELOG( "Error : InitD3D11() Failed." );
        return false;
    }

    // I.
    return true;
}

//-----------------------------------------------------------------------------------
//      AvP[VIs܂.
//-----------------------------------------------------------------------------------
void DemoApp::TermApp()
{
    // D3D11̏I.
    TermD3D11();

    // EBhȄI.
    TermWnd();
}

//------------------------------------------------------------------------------------
//      ftHg̃_[^[Qbg𐶐܂.
//------------------------------------------------------------------------------------
bool DemoApp::CreateDefaultRenderTarget()
{
    HRESULT hr = S_OK;

    // obNobt@擾.
    hr = m_pSwapChain->GetBuffer( 0, __uuidof( ID3D11Texture2D ), (LPVOID*)&m_pRTT );
    if ( FAILED( hr ) )
    {
        ELOG( "Error : IDXGISwapChain::GetBuffer() Failed" );
        return false;
    }

    // _[^[Qbg𐶐.
    hr = m_pDevice->CreateRenderTargetView( m_pRTT, NULL, &m_pRTV );
    if ( FAILED( hr ) )
    {
        ELOG( "Error : ID3D11Device::CreateRenderTargetView() Failed." );
        return false;
    }

    // _[^[Qbg̃VF[_\[Xr[𐶐.
    hr = m_pDevice->CreateShaderResourceView( m_pRTT, NULL, &m_pRTSRV );
    if ( FAILED( hr ) )
    {
        ELOG( "Error : ID3D11Device::CreateShaderResourceView() Failed." );
        return false;
    }

    return true;
}

//------------------------------------------------------------------------------------
//      ftHg̃_[^[Qbgj܂.
//------------------------------------------------------------------------------------
void DemoApp::ReleaseDefaultRenderTarget()
{
    // _[^[Qbg̃VF[_\[Xr[.
    if ( m_pRTSRV )
    {
        m_pRTSRV->Release();
        m_pRTSRV = NULL;
    }

    // _[^[Qbgr[.
    if ( m_pRTV )
    {
        m_pRTV->Release();
        m_pRTV = NULL;
    }

    // _[^[Qbg̃eNX`.
    if ( m_pRTT )
    {
        m_pRTT->Release();
        m_pRTT = NULL;
    }
}

//------------------------------------------------------------------------------------
//      ftHg̐[xXeVobt@𐶐܂.
//------------------------------------------------------------------------------------
bool DemoApp::CreateDefaultDepthStencil()
{
    HRESULT hr = S_OK;

    DXGI_FORMAT textureFormat  = m_DepthStencilFormat;
    DXGI_FORMAT resourceFormat = m_DepthStencilFormat;

    // eNX`ƃVF[_\[Xr[̃tH[}bgK؂Ȃ̂ɕύX.
    switch( m_DepthStencilFormat )
    {
    case DXGI_FORMAT_D16_UNORM:
        {
            textureFormat  = DXGI_FORMAT_R16_TYPELESS;
            resourceFormat = DXGI_FORMAT_R16_UNORM;
        }
        break;

    case DXGI_FORMAT_D24_UNORM_S8_UINT:
        {
            textureFormat  = DXGI_FORMAT_R24G8_TYPELESS;
            resourceFormat = DXGI_FORMAT_R24_UNORM_X8_TYPELESS;
        }
        break;

    case DXGI_FORMAT_D32_FLOAT:
        {
            textureFormat  = DXGI_FORMAT_R32_TYPELESS;
            resourceFormat = DXGI_FORMAT_R32_FLOAT;
        }
        break;

    case DXGI_FORMAT_D32_FLOAT_S8X24_UINT:
        {
            textureFormat  = DXGI_FORMAT_R32G8X24_TYPELESS;
            resourceFormat = DXGI_FORMAT_R32_FLOAT_X8X24_TYPELESS;
        }
        break;
    }

    // [xXeVeNX`̐.
    D3D11_TEXTURE2D_DESC td;
    ZeroMemory( &td, sizeof( D3D11_TEXTURE2D_DESC ) );
    td.Width                = m_Width;
    td.Height               = m_Height;
    td.MipLevels            = 1;
    td.ArraySize            = 1;
    td.Format               = textureFormat;
    td.SampleDesc.Count     = m_MultiSampleCount;
    td.SampleDesc.Quality   = m_MultiSampleQuality;
    td.Usage                = D3D11_USAGE_DEFAULT;
    td.BindFlags            = D3D11_BIND_DEPTH_STENCIL | D3D11_BIND_SHADER_RESOURCE;
    td.CPUAccessFlags       = 0;
    td.MiscFlags            = 0;

    // [xXeVeNX`̐.
    hr = m_pDevice->CreateTexture2D( &td, NULL, &m_pDST );
    if ( FAILED( hr ) )
    {
        ELOG( "Error : ID3D11Device::CreateTexture2D() Failed." );
        return false;
    }

    // [xXeVr[̐ݒ.
    D3D11_DEPTH_STENCIL_VIEW_DESC dsvd;
    ZeroMemory( &dsvd, sizeof( D3D11_DEPTH_STENCIL_VIEW_DESC ) );
    dsvd.Format         = m_DepthStencilFormat;
    if ( m_MultiSampleCount == 0 )
    {
        dsvd.ViewDimension      = D3D11_DSV_DIMENSION_TEXTURE2D;
        dsvd.Texture2D.MipSlice = 0;
    }
    else
    {
        dsvd.ViewDimension = D3D11_DSV_DIMENSION_TEXTURE2DMS;
    }


    // [xXeVr[̐.
    hr = m_pDevice->CreateDepthStencilView( m_pDST, &dsvd, &m_pDSV );
    if ( FAILED( hr ) )
    {
        ELOG( "Error : ID3D11Device::CreateDepthStencilView() Failed." );
        return false;
    }

    // VF[_\[Xr[̐ݒ.
    D3D11_SHADER_RESOURCE_VIEW_DESC srvd;
    ZeroMemory( &srvd, sizeof( D3D11_SHADER_RESOURCE_VIEW_DESC ) );
    srvd.Format                     = resourceFormat;

    if ( m_MultiSampleCount == 0 )
    {
        srvd.ViewDimension              = D3D11_SRV_DIMENSION_TEXTURE2D;
        srvd.Texture2D.MostDetailedMip  = 0;
        srvd.Texture2D.MipLevels        = 1;
    }
    else
    {
        srvd.ViewDimension = D3D11_SRV_DIMENSION_TEXTURE2DMS;
    }

    // VF[_\[Xr[𐶐.
    hr = m_pDevice->CreateShaderResourceView( m_pDST, &srvd, &m_pDSSRV );
    if ( FAILED( hr ) )
    { 
        ELOG( "Error : ID3D11Device::CreateShaderResourceView() Failed." ); 
        return false;
    }

    return true;
}

//------------------------------------------------------------------------------------
//      ftHg̐[xXeVobt@܂.
//------------------------------------------------------------------------------------
void DemoApp::ReleaseDefaultDepthStencil()
{
    // [xXeVobt@̃VF[_\[Xr[܂.
    if ( m_pDSSRV )
    {
        m_pDSSRV->Release();
        m_pDSSRV = NULL;
    }

    // [xXeVr[܂.
    if ( m_pDSV )
    {
        m_pDSV->Release();
        m_pDSV = NULL;
    }

    // [xXeVeNX`܂.
    if ( m_pDST )
    {
        m_pDST->Release();
        m_pDST = NULL;
    }
}

//-----------------------------------------------------------------------------------
//      ɍsł.
//-----------------------------------------------------------------------------------
bool DemoApp::OnInit()
{
    if ( m_pNode )
    {
        // ȅĂяo.
        if ( !m_pNode->OnInit( m_pDevice, m_pDeviceContext, m_Width, m_Height ) )
        {
            ELOG( "Error : SceneNode::OnInit() Failed." );
            return false;
        }

        // q̏Ăяo.
        for( UINT i=0; i<m_pNode->pChildren.size(); ++i )
        {
            if ( !m_pNode->pChildren[ i ]->OnInit( m_pDevice, m_pDeviceContext, m_Width, m_Height ) )
            {
                ELOG( "Error : SceneNode::OnInit() Failed. child index = %d", i );
                return false;
            }
        }
    }
    return true;
}

//-----------------------------------------------------------------------------------
//      Iɍsł.
//-----------------------------------------------------------------------------------
void DemoApp::OnTerm()
{
    if ( m_pNode )
    {
        // q̏IĂяo.
        for( UINT i=0; i<m_pNode->pChildren.size(); ++i )
        { m_pNode->pChildren[ i ]->OnTerm(); }

        // ȅIĂяo.
        m_pNode->OnTerm();
    }
}

//-----------------------------------------------------------------------------------
//      `掞ɍsł.
//-----------------------------------------------------------------------------------
void DemoApp::OnRender()
{
    assert( m_pRTV != NULL );
    assert( m_pDSV != NULL );

    // r[NA.
    m_pDeviceContext->ClearRenderTargetView( m_pRTV, m_ClearColor );
    m_pDeviceContext->ClearDepthStencilView( m_pDSV, D3D11_CLEAR_DEPTH | D3D11_CLEAR_STENCIL, 1.0f, 0 );

    if ( m_pNode )
    {
        // e̕`揈Ăяo.
        m_pNode->OnRender( m_pDevice, m_pDeviceContext );

        // q̕`揈Ăяo.
        for( UINT i=0; i<m_pNode->pChildren.size(); ++i )
        { m_pNode->pChildren[ i ]->OnRender( m_pDevice, m_pDeviceContext ); }
    }

    // `挋ʂ\܂.
    m_pSwapChain->Present( 0, 0 );
}

//-----------------------------------------------------------------------------------
//      TCYɍsł.
//-----------------------------------------------------------------------------------
void DemoApp::OnResize( const UINT w, const UINT h )
{
    if ( m_pSwapChain && m_pDeviceContext )
    {
        // EBhETCYݒ.
        m_Width       = w;
        m_Height      = h;

        // AXyNgZo.
        m_AspectRatio = (FLOAT)w / (FLOAT)h;

        // _[^[QbgNULLɐݒ.
        ID3D11RenderTargetView* pNull = NULL;
        m_pDeviceContext->OMSetRenderTargets( 1, &pNull, NULL );

        // _[^[Qbg.
        ReleaseDefaultRenderTarget();

        // [xXeVobt@.
        ReleaseDefaultDepthStencil();

        HRESULT hr = S_OK;

        // Xbv`FCTCY.
        hr = m_pSwapChain->ResizeBuffers( m_SwapChainCount, 0, 0, m_SwapChainFormat, 0 );
        if ( FAILED( hr ) )
        { ELOG( "Error : IDXGISwapChain::ResizeBuffer() Failed." ); }

        // _[^[Qbg𐶐.
        if ( !CreateDefaultRenderTarget() )
        { ELOG( "Error : CreateDefaultRenderTarget() Failed." ); }

        // [xXeVobt@𐶐.
        if ( !CreateDefaultDepthStencil() )
        { ELOG( "Error : CreateDefaultDepthStencil() Failed." ); }

        // foCXReLXgɃ_[^[Qbgݒ.
        m_pDeviceContext->OMSetRenderTargets( 1, &m_pRTV, m_pDSV );

        // r[|[g̐ݒ.
        D3D11_VIEWPORT vp;
        vp.Width    = (FLOAT)w;
        vp.Height   = (FLOAT)h;
        vp.MinDepth = 0.0f;
        vp.MaxDepth = 1.0f;
        vp.TopLeftX = 0;
        vp.TopLeftY = 0;

        // foCXReLXgɃr[|[gݒ.
        m_pDeviceContext->RSSetViewports( 1, &vp );

    }
    if ( m_pNode )
    {
        // TCYĂяo.
        m_pNode->OnResize( m_pDevice, m_pDeviceContext, w, h );

        // q̃TCYĂяo.
        for( UINT i=0; i<m_pNode->pChildren.size(); ++i )
        { m_pNode->pChildren[ i ]->OnResize( m_pDevice, m_pDeviceContext, w, h ); }
    }
}

//-----------------------------------------------------------------------------------
//      C[v.
//-----------------------------------------------------------------------------------
int DemoApp::MainLoop()
{
    MSG msg = { 0 };

    while( WM_QUIT != msg.message )
    {
        if ( PeekMessage( &msg, NULL, 0, 0, PM_REMOVE ) )
        {
            TranslateMessage( &msg );
            DispatchMessage( &msg );
        }
        else
        {
            OnRender();
        }
    }

    return (int)msg.wParam;
}

//-----------------------------------------------------------------------------------
//      AvP[Vs܂.
//-----------------------------------------------------------------------------------
int DemoApp::Run()
{
    int retcode = -1;

    // ɐ烁C[vs.
    if ( InitApp() )
    { retcode = MainLoop(); }

    // IĂяo.
    TermApp();

    // ^[R[hԋp.
    return retcode;
}

//-----------------------------------------------------------------------------------
//      EBhEvV[Wł.
//-----------------------------------------------------------------------------------
LRESULT CALLBACK DemoApp::WndProc( HWND hWnd, UINT uMsg, WPARAM wp, LPARAM lp )
{
    PAINTSTRUCT ps;
    HDC         hdc;

    switch( uMsg )
    {
    case WM_PAINT:
        {
            hdc = BeginPaint( hWnd, &ps );
            EndPaint( hWnd, &ps );
        }
        break;

    case WM_DESTROY:
        { PostQuitMessage( 0 ); }
        break;

    case WM_SIZE:
        {
            UINT w = (UINT)LOWORD( lp );
            UINT h = (UINT)HIWORD( lp );
            s_pThis->OnResize( w, h );
        }
        break;

    default:
        { /* DO_NOTHING */ }
        break;
    }

    return DefWindowProc( hWnd, uMsg, wp, lp );
}

//-----------------------------------------------------------------------------------
//      m[hݒ肵܂.
//-----------------------------------------------------------------------------------
void DemoApp::SetNode( SceneNode* pNode )
{ m_pNode = pNode; }

//-----------------------------------------------------------------------------------
//      m[h擾܂.
//-----------------------------------------------------------------------------------
SceneNode* DemoApp::GetNode() const
{ return m_pNode; }

//-----------------------------------------------------------------------------------
//      foCX擾܂.
//-----------------------------------------------------------------------------------
ID3D11Device* DemoApp::GetDevice() const
{ return m_pDevice; }

//-----------------------------------------------------------------------------------
//      foCXReLXg擾܂.
//-----------------------------------------------------------------------------------
ID3D11DeviceContext* DemoApp::GetDeviceContext() const
{ return m_pDeviceContext; }

//-----------------------------------------------------------------------------------
//      Xbv`FC擾܂.
//-----------------------------------------------------------------------------------
IDXGISwapChain* DemoApp::GetSwapChain() const
{ return m_pSwapChain; }

//-----------------------------------------------------------------------------------
//      _[^[Qbgr[擾܂.
//-----------------------------------------------------------------------------------
ID3D11RenderTargetView* DemoApp::GetRenderTargetView() const
{ return m_pRTV; }

//-----------------------------------------------------------------------------------
//      [xXeVr[擾܂.
//-----------------------------------------------------------------------------------
ID3D11DepthStencilView* DemoApp::GetDepthStencilView() const
{ return m_pDSV; }

//-----------------------------------------------------------------------------------
//      [xXeṼVF[_肻[r[擾܂.
//-----------------------------------------------------------------------------------
ID3D11ShaderResourceView* DemoApp::GetDepthStencilShaderResourceView() const
{ return m_pDSSRV; }

//-----------------------------------------------------------------------------------
//      EBhẺ擾܂.
//-----------------------------------------------------------------------------------
UINT DemoApp::GetWidth() const
{ return m_Width; }

//-----------------------------------------------------------------------------------
//      EBhȄc擾܂.
//-----------------------------------------------------------------------------------
UINT DemoApp::GetHeight() const
{ return m_Height; }

//-----------------------------------------------------------------------------------
//      ANeBuȃAvP[V擾܂.
//-----------------------------------------------------------------------------------
DemoApp* DemoApp::GetActive()
{ return s_pThis; }