//-----------------------------------------------------------------------------------
// File : Simple.fx
// Desc : Shader For Simple Demo.
// Copyright(c) Project Asura. All right reserved.
//-----------------------------------------------------------------------------------

/////////////////////////////////////////////////////////////////////////////////////
// CBPerFrame constant buffer
/////////////////////////////////////////////////////////////////////////////////////
cbuffer CBPerFrame : register( b0 )
{
    matrix  World;  //!< [hs.
    matrix  View;   //!< r[s.
    matrix  Proj;   //!< ˉes.
};

/////////////////////////////////////////////////////////////////////////////////////
// VSInput structure
/////////////////////////////////////////////////////////////////////////////////////
struct VSInput
{
    float3 Position : POSITION;     //!< ʒuWł.
};

/////////////////////////////////////////////////////////////////////////////////////
// GSPSInput structure
/////////////////////////////////////////////////////////////////////////////////////
struct GSPSInput
{
    float4 Position : SV_POSITION;  //!< ʒuWł.
};

//-----------------------------------------------------------------------------------
//! @brief      _VF[_Gg[|Cgł.
//-----------------------------------------------------------------------------------
GSPSInput VSFunc( VSInput input )
{
    GSPSInput output = (GSPSInput)0;

    // ̓f[^̂܂ܗ.
    output.Position = float4( input.Position, 1.0f );

    return output;
}

//-----------------------------------------------------------------------------------
//! @brief      WIgVF[_Gg[|Cgł.
//-----------------------------------------------------------------------------------
[maxvertexcount(3)]
void GSFunc( triangle GSPSInput input[3], inout TriangleStream<GSPSInput> stream )
{
    for( int i=0; i<3; ++i )
    {
        GSPSInput output = (GSPSInput)0;

        // [hԂɕϊ.
        float4 worldPos = mul( World, input[ i ].Position );

        // r[Ԃɕϊ.
        float4 viewPos  = mul( View,  worldPos );

        // ˉeԂɕϊ.
        float4 projPos  = mul( Proj,  viewPos );

        // o͒lݒ.
        output.Position = projPos;

        // Xg[ɒǉ.
        stream.Append( output );
    }
    stream.RestartStrip();
}

//------------------------------------------------------------------------------------
//! @brief      sNZVF[_Gg[|Cgł.
//------------------------------------------------------------------------------------
float4 PSFunc( GSPSInput output ) : SV_TARGET0
{
    return float4( 0.25f, 1.0f, 0.25f, 1.0f );
}
