//-----------------------------------------------------------------------------------
// File : SceneNode.h
// Desc : Scene Node Module.
// Copyright(c) Project Asura. All right reserved.
//-----------------------------------------------------------------------------------

#ifndef __SCENE_NODE_H__
#define __SCENE_NODE_H__

//-----------------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------------
#include <d3d11.h>
#include <vector>


#ifndef UNUSED_VAR
#define UNUSED_VAR(x)   ((void*)&x)
#endif//UNUSED_VAR


/////////////////////////////////////////////////////////////////////////////////////
// SceneNode structure
/////////////////////////////////////////////////////////////////////////////////////
struct SceneNode
{
    SceneNode*              pParent;        //!< eւ̃|C^.
    std::vector<SceneNode*> pChildren;      //!< qւ̃|C^.

    //-------------------------------------------------------------------------------
    //! @brief      RXgN^ł.
    //-------------------------------------------------------------------------------
    SceneNode()
    : pParent( NULL )
    { pChildren.clear(); }

    //-------------------------------------------------------------------------------
    //! @brief      fXgN^ł.
    //-------------------------------------------------------------------------------
    virtual ~SceneNode()
    {
        RemoveChildren();
        OnTerm();
    }

    //-------------------------------------------------------------------------------
    //! @brief      qǉ܂.
    //-------------------------------------------------------------------------------
    void AddChild( SceneNode* pChild )
    { pChildren.push_back( pChild ); }

    //-------------------------------------------------------------------------------
    //! @brief      q菜܂.
    //-------------------------------------------------------------------------------
    void RemoveChildren()
    {
        // q̏IĂяo܂.
        for( size_t i=0; i<pChildren.size(); ++i )
        {
            pChildren[ i ]->RemoveChildren();
            pChildren[ i ]->OnTerm();
        }

        // ܂.
        pChildren.clear();
    }

    //-------------------------------------------------------------------------------
    //! @brief      ɍsł.
    //-------------------------------------------------------------------------------
    virtual bool OnInit( ID3D11Device* pDevice, ID3D11DeviceContext* pDeviceContext, const UINT width, const UINT height )
    {
        UNUSED_VAR( pDevice );
        UNUSED_VAR( pDeviceContext );
        UNUSED_VAR( width );
        UNUSED_VAR( height );

        /* DO_NOTHING */

        return true;
    }

    //-------------------------------------------------------------------------------
    //! @brief      `掞ɍsł.
    //-------------------------------------------------------------------------------
    virtual void OnRender( ID3D11Device* pDevice, ID3D11DeviceContext* pDeviceContext )
    {
        UNUSED_VAR( pDevice );
        UNUSED_VAR( pDeviceContext );

        /* DO_NOTHING */
    }

    //-------------------------------------------------------------------------------
    //! @brief      TCYɍsł.
    //-------------------------------------------------------------------------------
    virtual void OnResize( ID3D11Device* pDevice, ID3D11DeviceContext* pDeviceContext, const UINT width, const UINT height )
    {
        UNUSED_VAR( pDevice );
        UNUSED_VAR( pDeviceContext );
        UNUSED_VAR( width );
        UNUSED_VAR( height );

        /* DO_NOTHING */ 
    }

    //-------------------------------------------------------------------------------
    //! @brief      Iɍsł.
    //-------------------------------------------------------------------------------
    virtual void OnTerm()
    { /* DO_NOTHING */ }
};


#endif//__SCENE_NODE_H__