//---------------------------------------------------------------------------------------
// File : DemoNode.h
// Desc : Demo Node Module.
// Copyright(c) Project Asura. All right reserved.
//---------------------------------------------------------------------------------------

#ifndef __DEMO_NODE_H__
#define __DEMO_NODE_H__

//---------------------------------------------------------------------------------------
// Includes
//---------------------------------------------------------------------------------------
#include <DirectXMath.h>
#include "SceneNode.h"



/////////////////////////////////////////////////////////////////////////////////////////
// DemoNode class
/////////////////////////////////////////////////////////////////////////////////////////
class DemoNode : public SceneNode
{
    //===================================================================================
    // list of friend classed and methods
    //===================================================================================
    /* NOTHING */

private:
    //===================================================================================
    // private variables
    //===================================================================================
    ID3D11VertexShader*         m_pVS;          //!< _VF[_ł.
    ID3D11GeometryShader*       m_pGS;          //!< WIgVF[_ł.
    ID3D11PixelShader*          m_pPS;          //!< sNZVF[_ł.
    ID3D11InputLayout*          m_pIL;          //!< ̓CAEgł.
    ID3D11Buffer*               m_pVB;          //!< _obt@ł.
    ID3D11Buffer*               m_pCB;          //!< 萔obt@ł.
    DirectX::XMMATRIX           m_World;        //!< [hsł.
    DirectX::XMMATRIX           m_View;         //!< r[sł.
    DirectX::XMMATRIX           m_Proj;         //!< ˉesł.

    //===================================================================================
    // private methods
    //===================================================================================
    /* NOTHING */

protected:
    //===================================================================================
    // protected variables
    //===================================================================================
    /* NOTHING */

    //===================================================================================
    // protected methods
    //===================================================================================
    /* NOTHING */

public:
    //===================================================================================
    // public variables
    //===================================================================================
    /* NOTHING */

    //===================================================================================
    // public methods
    //===================================================================================

    //-----------------------------------------------------------------------------------
    //! @brief      RXgN^ł.
    //-----------------------------------------------------------------------------------
    DemoNode();

    //-----------------------------------------------------------------------------------
    //! @brief      fXgN^ł.
    //-----------------------------------------------------------------------------------
    virtual ~DemoNode();

    //-----------------------------------------------------------------------------------
    //! @brief      ̏ł.
    //-----------------------------------------------------------------------------------
    virtual bool OnInit( ID3D11Device* pDevice, ID3D11DeviceContext* pDeviceContext, const UINT width, const UINT height );

    //-----------------------------------------------------------------------------------
    //! @brief      `掞̏ł.
    //-----------------------------------------------------------------------------------
    virtual void OnRender( ID3D11Device* pDevice, ID3D11DeviceContext* pDeviceContext );

    //-----------------------------------------------------------------------------------
    //! @brief      TCY̏ł.
    //-----------------------------------------------------------------------------------
    virtual void OnResize( ID3D11Device* pDevice, ID3D11DeviceContext* pDeviceContext, const UINT width, const UINT height );

    //-----------------------------------------------------------------------------------
    //! @brief      Ȉł.
    //-----------------------------------------------------------------------------------
    virtual void OnTerm();
};


#endif//__DEMO_NODE_H__